/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.bundle.RuntimeEnabledSdkConfigProto;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.ClassesDexEntriesMutator;
import com.android.tools.build.bundletool.model.ResourceTablePackageIdRemapper;
import com.android.tools.build.bundletool.model.SdkBundle;
import com.android.tools.build.bundletool.model.XmlPackageIdRemapper;

public final class SdkBundleModuleToAppBundleModuleConverter {
    private final SdkBundle sdkBundle;
    private final ResourceTablePackageIdRemapper resourceTablePackageIdRemapper;
    private final XmlPackageIdRemapper xmlPackageIdRemapper;
    private final ClassesDexEntriesMutator classesDexEntriesMutator;

    public SdkBundleModuleToAppBundleModuleConverter(SdkBundle sdkBundle, RuntimeEnabledSdkConfigProto.RuntimeEnabledSdk dependencyConfig) {
        this.sdkBundle = sdkBundle;
        this.resourceTablePackageIdRemapper = new ResourceTablePackageIdRemapper(dependencyConfig.getResourcesPackageId());
        this.xmlPackageIdRemapper = new XmlPackageIdRemapper(dependencyConfig.getResourcesPackageId());
        this.classesDexEntriesMutator = new ClassesDexEntriesMutator();
    }

    public BundleModule convert() {
        return this.convertNameTypeAndManifest(this.removeRPackageDexFile(this.remapResourceIdsInXmlResources(this.remapResourceIdsInResourceTable(this.sdkBundle.getModule()))));
    }

    private BundleModule remapResourceIdsInResourceTable(BundleModule module) {
        return this.resourceTablePackageIdRemapper.remap(module);
    }

    private BundleModule remapResourceIdsInXmlResources(BundleModule module) {
        return this.xmlPackageIdRemapper.remap(module);
    }

    private BundleModule removeRPackageDexFile(BundleModule module) {
        return this.classesDexEntriesMutator.applyMutation(module, ClassesDexEntriesMutator.R_PACKAGE_DEX_ENTRY_REMOVER);
    }

    private BundleModule convertNameTypeAndManifest(BundleModule module) {
        String sdkModuleName = this.sdkBundle.getPackageName().replace(".", "");
        return module.toBuilder().setName(BundleModuleName.create(sdkModuleName)).setModuleType(BundleModule.ModuleType.SDK_DEPENDENCY_MODULE).setAndroidManifest(this.sdkBundle.getModule().getAndroidManifest().toEditor().removeUsesSdkElement().setSplitIdForFeatureSplit(sdkModuleName).setDeliveryOptionsForRuntimeEnabledSdkModule().save()).build();
    }
}

