/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model.utils;

import com.android.aapt.Resources;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.ResourceId;
import com.android.tools.build.bundletool.model.ResourceInjector;
import com.android.tools.build.bundletool.model.VariantKey;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.utils.ResourcesUtils;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoAttributeBuilder;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoElementBuilder;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteSource;
import java.util.List;

public class LocaleConfigXmlInjector {
    private static final String XML_TYPE_NAME = "xml";
    private static final String RESOURCE_PATH = "res/xml/locales_config.xml";
    private static final String RESOURCE_FILE_NAME = "locales_config";
    private static final String LOCALE_CONFIG_ELEMENT = "locale-config";
    private static final String LOCALE_ELEMENT = "locale";

    public ImmutableList<ModuleSplit> process(VariantKey variantKey, ImmutableList<ModuleSplit> splits) {
        switch (variantKey.getSplitType()) {
            case SYSTEM: 
            case SPLIT: {
                return LocaleConfigXmlInjector.processSplitApkVariant(splits);
            }
            case STANDALONE: 
            case INSTANT: 
            case ARCHIVE: {
                return splits;
            }
            case ASSET_SLICE: {
                throw new IllegalStateException("Unexpected Asset Slice inside variant.");
            }
        }
        throw new IllegalStateException(String.format("Unknown split type %s", new Object[]{variantKey.getSplitType()}));
    }

    private static ImmutableList<ModuleSplit> processSplitApkVariant(ImmutableList<ModuleSplit> splits) {
        boolean hasLanguageSplits = splits.stream().anyMatch(split -> split.isBaseModuleSplit() && split.getApkTargeting().hasLanguageTargeting());
        Resources.XmlNode localesXmlContent = LocaleConfigXmlInjector.createLocalesXmlNode(splits);
        ImmutableList.Builder result = new ImmutableList.Builder();
        for (ModuleSplit split2 : splits) {
            if (split2.isMasterSplit() && split2.isBaseModuleSplit() && split2.getResourceTable().isPresent() && hasLanguageSplits && !split2.getAndroidManifest().hasLocaleConfig() && !split2.findEntry(ZipPath.create(RESOURCE_PATH)).isPresent()) {
                result.add((Object)LocaleConfigXmlInjector.injectLocaleConfigXml(split2, localesXmlContent));
                continue;
            }
            result.add((Object)split2);
        }
        return result.build();
    }

    private static ModuleSplit injectLocaleConfigXml(ModuleSplit split, Resources.XmlNode xmlNode) {
        ResourceInjector resourceInjector = ResourceInjector.fromModuleSplit(split);
        ResourceId resourceId = resourceInjector.addResource(XML_TYPE_NAME, LocaleConfigXmlInjector.createXmlEntry());
        ModuleEntry localesConfigEntry = LocaleConfigXmlInjector.addLocalesConfigEntry(xmlNode);
        return split.toBuilder().setResourceTable(resourceInjector.build()).setEntries((List<ModuleEntry>)ImmutableList.builder().addAll(split.getEntries()).add((Object)localesConfigEntry).build()).setAndroidManifest(split.getAndroidManifest().toEditor().setLocaleConfig(resourceId.getFullResourceId()).save()).build();
    }

    private static ModuleEntry addLocalesConfigEntry(Resources.XmlNode xmlNode) {
        return ModuleEntry.builder().setPath(ZipPath.create(RESOURCE_PATH)).setContent(ByteSource.wrap((byte[])xmlNode.toByteArray())).build();
    }

    public static Resources.XmlNode createLocalesXmlNode(ImmutableList<ModuleSplit> splits) {
        ImmutableSet<String> allLocales = LocaleConfigXmlInjector.getLocalesFromBaseModuleSplits(splits);
        XmlProtoElementBuilder localesConfigXml = XmlProtoElementBuilder.create(LOCALE_CONFIG_ELEMENT);
        allLocales.stream().filter(locale -> !locale.isEmpty()).forEach(locale -> localesConfigXml.addChildElement(LocaleConfigXmlInjector.createAttributes(locale)));
        return XmlProtoNode.createElementNode(localesConfigXml.build()).getProto();
    }

    private static ImmutableSet<String> getLocalesFromBaseModuleSplits(ImmutableList<ModuleSplit> splits) {
        return (ImmutableSet)splits.stream().filter(ModuleSplit::isBaseModuleSplit).filter(split -> split.getResourceTable().isPresent()).flatMap(split -> ResourcesUtils.getAllLocales(split.getResourceTable().get()).stream()).filter(locale -> !locale.isEmpty()).collect(ImmutableSet.toImmutableSet());
    }

    private static XmlProtoElementBuilder createAttributes(String locale) {
        return XmlProtoElementBuilder.create(LOCALE_ELEMENT).addAttribute(XmlProtoAttributeBuilder.createAndroidAttribute("name", 0x1010003).setValueAsString(locale));
    }

    private static Resources.Entry createXmlEntry() {
        return Resources.Entry.newBuilder().setName(RESOURCE_FILE_NAME).addConfigValue(Resources.ConfigValue.newBuilder().setValue(Resources.Value.newBuilder().setItem(Resources.Item.newBuilder().setFile(Resources.FileReference.newBuilder().setPath(RESOURCE_PATH).setType(Resources.FileReference.Type.PROTO_XML))))).build();
    }
}

