/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.ddmlib.logcat;

import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import shadow.bundletool.com.android.ddmlib.AdbCommandRejectedException;
import shadow.bundletool.com.android.ddmlib.IDevice;
import shadow.bundletool.com.android.ddmlib.Log;
import shadow.bundletool.com.android.ddmlib.MultiLineReceiver;
import shadow.bundletool.com.android.ddmlib.ShellCommandUnresponsiveException;
import shadow.bundletool.com.android.ddmlib.TimeoutException;
import shadow.bundletool.com.android.ddmlib.logcat.LogCatHeader;
import shadow.bundletool.com.android.ddmlib.logcat.LogCatListener;
import shadow.bundletool.com.android.ddmlib.logcat.LogCatMessage;
import shadow.bundletool.com.android.ddmlib.logcat.LogCatMessageParser;

public class LogCatReceiverTask
implements Runnable {
    private static final String LOGCAT_COMMAND = "logcat -v long";
    private static final int DEVICE_POLL_INTERVAL_MSEC = 1000;
    private static final LogCatMessage sDeviceDisconnectedMsg = LogCatReceiverTask.newLogCatMessage("Device disconnected: 1");
    private static final LogCatMessage sConnectionTimeoutMsg = LogCatReceiverTask.newLogCatMessage("LogCat Connection timed out");
    private static final LogCatMessage sConnectionErrorMsg = LogCatReceiverTask.newLogCatMessage("LogCat Connection error");
    private final IDevice mDevice;
    private final LogCatOutputReceiver mReceiver;
    private final LogCatMessageParser mParser;
    private final AtomicBoolean mCancelled;
    private final Set<LogCatListener> mListeners = new HashSet<LogCatListener>();

    public LogCatReceiverTask(IDevice device) {
        this.mDevice = device;
        this.mReceiver = new LogCatOutputReceiver();
        this.mParser = new LogCatMessageParser();
        this.mCancelled = new AtomicBoolean();
    }

    @Override
    public void run() {
        while (!this.mDevice.isOnline()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e11) {
                return;
            }
        }
        try {
            this.mDevice.executeShellCommand(LOGCAT_COMMAND, this.mReceiver, 0);
        }
        catch (TimeoutException e12) {
            this.notifyListeners(Collections.singletonList(sConnectionTimeoutMsg));
        }
        catch (AdbCommandRejectedException e12) {
        }
        catch (ShellCommandUnresponsiveException e12) {
        }
        catch (IOException e13) {
            this.notifyListeners(Collections.singletonList(sConnectionErrorMsg));
        }
        this.notifyListeners(Collections.singletonList(sDeviceDisconnectedMsg));
    }

    public void stop() {
        this.mCancelled.set(true);
    }

    public synchronized void addLogCatListener(LogCatListener l11) {
        this.mListeners.add(l11);
    }

    public synchronized void removeLogCatListener(LogCatListener l11) {
        this.mListeners.remove(l11);
    }

    private synchronized void notifyListeners(List<LogCatMessage> messages) {
        for (LogCatListener l11 : this.mListeners) {
            l11.log(messages);
        }
    }

    private static LogCatMessage newLogCatMessage(String message2) {
        return new LogCatMessage(new LogCatHeader(Log.LogLevel.ERROR, -1, -1, "", "", Instant.EPOCH), message2);
    }

    private class LogCatOutputReceiver
    extends MultiLineReceiver {
        public LogCatOutputReceiver() {
            this.setTrimLine(false);
        }

        @Override
        public boolean isCancelled() {
            return LogCatReceiverTask.this.mCancelled.get();
        }

        @Override
        public void processNewLines(String[] lines) {
            if (!LogCatReceiverTask.this.mCancelled.get()) {
                this.processLogLines(lines);
            }
        }

        private void processLogLines(String[] lines) {
            List<LogCatMessage> newMessages = LogCatReceiverTask.this.mParser.processLogLines(lines, LogCatReceiverTask.this.mDevice);
            if (!newMessages.isEmpty()) {
                LogCatReceiverTask.this.notifyListeners(newMessages);
            }
        }
    }
}

