/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.archive;

import com.android.aapt.Resources;
import com.android.tools.build.bundletool.archive.ArchivedAndroidManifestUtils;
import com.android.tools.build.bundletool.archive.ArchivedResourcesUtils;
import com.android.tools.build.bundletool.commands.BuildApksModule;
import com.android.tools.build.bundletool.model.AndroidManifest;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.ResourceId;
import com.android.tools.build.bundletool.model.ResourceInjector;
import com.android.tools.build.bundletool.model.ResourceTableEntry;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.exceptions.InvalidCommandException;
import com.android.tools.build.bundletool.model.utils.ResourcesUtils;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoAttribute;
import com.android.tools.build.bundletool.model.version.BundleToolVersion;
import com.android.tools.build.bundletool.model.version.Version;
import com.android.tools.build.bundletool.model.version.VersionGuardedFeature;
import com.android.tools.build.bundletool.splitters.ResourceAnalyzer;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.util.Optional;
import javax.inject.Inject;

public final class ArchivedApksGenerator {
    private final boolean updateIconInArchiveMode;

    @Inject
    ArchivedApksGenerator(@BuildApksModule.UpdateIconInArchiveMode boolean updateIconInArchiveMode) {
        this.updateIconInArchiveMode = updateIconInArchiveMode;
    }

    public ModuleSplit generateArchivedApk(AppBundle appBundle, Optional<String> customAppStorePackageName) throws IOException {
        this.validateRequest(appBundle);
        BundleModule baseModule = appBundle.getBaseModule();
        AndroidManifest archivedManifest = ArchivedAndroidManifestUtils.createArchivedManifest(baseModule.getAndroidManifest());
        Resources.ResourceTable archivedResourceTable = this.getArchivedResourceTable(appBundle, baseModule, archivedManifest);
        Optional<XmlProtoAttribute> iconAttribute = archivedManifest.getIconAttribute();
        Optional<XmlProtoAttribute> roundIconAttribute = archivedManifest.getRoundIconAttribute();
        ResourceInjector resourceInjector = new ResourceInjector(archivedResourceTable.toBuilder(), appBundle.getPackageName());
        ImmutableMap<ZipPath, ByteSource> additionalResourcesByByteSource = ImmutableMap.of();
        if (this.updateIconInArchiveMode) {
            ImmutableMap<String, Integer> extraResourceNameToIdMap = ArchivedResourcesUtils.injectExtraResources(resourceInjector, customAppStorePackageName, iconAttribute, roundIconAttribute);
            additionalResourcesByByteSource = ArchivedResourcesUtils.buildAdditionalResourcesByByteSourceMap((Integer)extraResourceNameToIdMap.get((Object)"com_android_vending_archive_icon_cloud_symbol"), (Integer)extraResourceNameToIdMap.get((Object)"com_android_vending_archive_icon_opacity_layer"), iconAttribute, roundIconAttribute);
            archivedManifest = ArchivedAndroidManifestUtils.updateArchivedIcons(archivedManifest, extraResourceNameToIdMap);
        } else {
            resourceInjector.addStringResource("reactivation_app_store_package_name", ArchivedResourcesUtils.getAppStorePackageName(customAppStorePackageName));
            additionalResourcesByByteSource = ImmutableMap.of((Object)BundleModule.DEX_DIRECTORY.resolve("classes.dex"), (Object)ArchivedResourcesUtils.getResourceByteSource("dex/classes.dex"));
        }
        return ModuleSplit.forArchive(baseModule, archivedManifest, resourceInjector.build(), additionalResourcesByByteSource);
    }

    private void validateRequest(AppBundle appBundle) {
        boolean isStoreArchiveEnabledByDefault;
        Preconditions.checkNotNull((Object)appBundle);
        Version bundletoolVersion = BundleToolVersion.getVersionFromBundleConfig(appBundle.getBundleConfig());
        if (!VersionGuardedFeature.ARCHIVED_APK_GENERATION.enabledForVersion(bundletoolVersion)) {
            throw InvalidCommandException.builder().withInternalMessage(String.format("Archived APK can only be generated for bundles built with version %s or higher.", VersionGuardedFeature.ARCHIVED_APK_GENERATION.getEnabledSinceVersion())).build();
        }
        Optional<Boolean> storeArchiveConfig = appBundle.getStoreArchive();
        if (!storeArchiveConfig.orElse(isStoreArchiveEnabledByDefault = VersionGuardedFeature.STORE_ARCHIVE_ENABLED_BY_DEFAULT.enabledForVersion(bundletoolVersion)).booleanValue()) {
            throw InvalidCommandException.builder().withInternalMessage("Archived APK cannot be generated when Store Archive configuration is disabled.").build();
        }
        if (appBundle.getBaseModule().getAndroidManifest().isHeadless()) {
            throw InvalidCommandException.builder().withInternalMessage("Archived APK can not be generated for applications without a launcher activity.").build();
        }
    }

    private Resources.ResourceTable getArchivedResourceTable(AppBundle appBundle, BundleModule bundleModule, AndroidManifest archivedManifest) throws IOException {
        Resources.ResourceTable.Builder archivedResourceTable = Resources.ResourceTable.newBuilder();
        if (bundleModule.getResourceTable().isPresent()) {
            ImmutableSet<ResourceId> referredResources = new ResourceAnalyzer(appBundle).findAllAppResourcesReachableFromManifest(archivedManifest);
            archivedResourceTable = ResourcesUtils.filterResourceTable(bundleModule.getResourceTable().get(), entry -> !referredResources.contains((Object)entry.getResourceId()), ResourceTableEntry::getEntry).toBuilder();
        }
        return archivedResourceTable.build();
    }
}

