/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.sdkmodule;

import com.android.bundle.SdkModulesConfigOuterClass;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.sdkmodule.DexRepackager;
import com.android.tools.build.bundletool.sdkmodule.JavaResourceRepackager;
import com.android.tools.build.bundletool.xml.XmlUtils;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteSource;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DexAndResourceRepackager {
    private static final String COMPAT_CONFIG_ELEMENT_NAME = "compat-config";
    private static final String COMPAT_ENTRYPOINT_ELEMENT_NAME = "compat-entrypoint";
    private static final String DEX_PATH_ELEMENT_NAME = "dex-path";
    private static final String JAVA_RESOURCE_PATH_ELEMENT_NAME = "java-resource-path";
    private static final String COMPAT_SDK_CONFIG_FILE_NAME = "CompatSdkConfig.xml";
    private static final String ASSETS_SUBDIRECTORY_PREFIX = "assets/RuntimeEnabledSdk-";
    private final SdkModulesConfigOuterClass.SdkModulesConfig sdkModulesConfig;
    private final DexRepackager dexRepackager;
    private final JavaResourceRepackager javaResourceRepackager;

    DexAndResourceRepackager(SdkModulesConfigOuterClass.SdkModulesConfig sdkModulesConfig) {
        this.sdkModulesConfig = sdkModulesConfig;
        this.dexRepackager = new DexRepackager(sdkModulesConfig);
        this.javaResourceRepackager = new JavaResourceRepackager(sdkModulesConfig);
    }

    BundleModule repackage(BundleModule module) {
        Preconditions.checkArgument((!module.getEntry(this.getCompatSdkConfigPath()).isPresent() ? 1 : 0) != 0, (String)"Unable to generate %s for %s, because file already exists.", (Object)COMPAT_SDK_CONFIG_FILE_NAME, (Object)this.sdkModulesConfig.getSdkPackageName());
        module = this.dexRepackager.applyMutation(module);
        module = this.javaResourceRepackager.applyMutation(module);
        return module.toBuilder().addEntry(this.getCompatSdkConfigModuleEntry(module)).build();
    }

    public static String getCompatSdkConfigPath(String sdkPackageName) {
        return ASSETS_SUBDIRECTORY_PREFIX + sdkPackageName + "/" + COMPAT_SDK_CONFIG_FILE_NAME;
    }

    private ZipPath getCompatSdkConfigPath() {
        return ZipPath.create(DexAndResourceRepackager.getCompatSdkConfigPath(this.sdkModulesConfig.getSdkPackageName()));
    }

    private ModuleEntry getCompatSdkConfigModuleEntry(BundleModule repackagedModule) {
        return ModuleEntry.builder().setPath(this.getCompatSdkConfigPath()).setContent(ByteSource.wrap((byte[])XmlUtils.documentToString(this.getCompatSdkConfig(repackagedModule)).getBytes(StandardCharsets.UTF_8))).build();
    }

    private Document getCompatSdkConfig(BundleModule repackagedModule) {
        Document compatSdkConfig;
        try {
            compatSdkConfig = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e11) {
            throw new IllegalStateException(e11);
        }
        compatSdkConfig.appendChild(this.createCompatConfigXmlNode(compatSdkConfig, repackagedModule));
        return compatSdkConfig;
    }

    private Node createCompatConfigXmlNode(Document xmlFactory, BundleModule repackagedModule) {
        Element compatConfigElement = xmlFactory.createElement(COMPAT_CONFIG_ELEMENT_NAME);
        if (!this.sdkModulesConfig.getCompatSdkProviderClassName().isEmpty()) {
            Element compatEntrypointElement = xmlFactory.createElement(COMPAT_ENTRYPOINT_ELEMENT_NAME);
            compatEntrypointElement.setTextContent(this.sdkModulesConfig.getCompatSdkProviderClassName());
            compatConfigElement.appendChild(compatEntrypointElement);
        }
        this.appendDexPathsToElement(compatConfigElement, xmlFactory, repackagedModule);
        this.appendJavaResourcePathsToElement(compatConfigElement, xmlFactory, repackagedModule);
        return compatConfigElement;
    }

    private void appendDexPathsToElement(Element compatConfigElement, Document xmlFactory, BundleModule repackagedModule) {
        repackagedModule.getEntries().stream().filter(entry -> entry.getPath().startsWith(this.dexRepackager.getNewDexDirectoryPath())).map(entry -> {
            Element dexPathElement = xmlFactory.createElement(DEX_PATH_ELEMENT_NAME);
            dexPathElement.setTextContent(entry.getPath().toString());
            return dexPathElement;
        }).forEach(compatConfigElement::appendChild);
    }

    private void appendJavaResourcePathsToElement(Element compatConfigElement, Document xmlFactory, BundleModule repackagedModule) {
        repackagedModule.getEntries().stream().filter(entry -> entry.getPath().startsWith(this.javaResourceRepackager.getNewJavaResourceDirectoryPath())).map(entry -> {
            Element javaResourcePathElement = xmlFactory.createElement(JAVA_RESOURCE_PATH_ELEMENT_NAME);
            javaResourcePathElement.setTextContent(entry.getPath().toString());
            return javaResourcePathElement;
        }).forEach(compatConfigElement::appendChild);
    }
}

