/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.sdkmodule;

import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleEntriesMutator;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ZipPath;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RPackageDexEntryRemover
extends ModuleEntriesMutator {
    private static final Pattern CLASSES_DEX_REGEX_PATTERN = Pattern.compile("dex/classes(\\d*)\\.dex");

    @Override
    public Predicate<ModuleEntry> getFilter() {
        return entry -> entry.getPath().toString().matches(CLASSES_DEX_REGEX_PATTERN.pattern());
    }

    @Override
    public Function<ImmutableList<ModuleEntry>, ImmutableList<ModuleEntry>> getMutator() {
        return dexEntries -> (ImmutableList)dexEntries.stream().sorted(Comparator.comparing(dexEntry -> RPackageDexEntryRemover.getClassesIndexForDexPath(dexEntry.getPath()))).limit(Math.max(dexEntries.size() - 1, 0)).collect(ImmutableList.toImmutableList());
    }

    @Override
    public boolean shouldApplyMutation(BundleModule module) {
        return true;
    }

    private static int getClassesIndexForDexPath(ZipPath entryPath) {
        String fileName = entryPath.toString();
        Matcher matcher = CLASSES_DEX_REGEX_PATTERN.matcher(fileName);
        Preconditions.checkState((boolean)matcher.matches());
        String num = matcher.group(1);
        if (num.isEmpty()) {
            return 0;
        }
        return Integer.parseInt(num);
    }
}

