/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.sdkmodule;

import com.android.bundle.RuntimeEnabledSdkConfigProto;
import com.android.bundle.SdkModulesConfigOuterClass;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.sdkmodule.DexAndResourceRepackager;
import com.android.tools.build.bundletool.sdkmodule.RPackageDexEntryRemover;
import com.android.tools.build.bundletool.sdkmodule.ResourceTablePackageIdRemapper;
import com.android.tools.build.bundletool.sdkmodule.XmlPackageIdRemapper;

public final class SdkModuleToAppBundleModuleConverter {
    private final String sdkPackageName;
    private final BundleModule sdkModule;
    private final ResourceTablePackageIdRemapper resourceTablePackageIdRemapper;
    private final XmlPackageIdRemapper xmlPackageIdRemapper;
    private final RPackageDexEntryRemover rPackageDexEntryRemover;
    private final DexAndResourceRepackager dexAndResourceRepackager;

    public SdkModuleToAppBundleModuleConverter(String sdkPackageName, BundleModule sdkModule, RuntimeEnabledSdkConfigProto.RuntimeEnabledSdk dependencyConfig, SdkModulesConfigOuterClass.SdkModulesConfig sdkModulesConfig) {
        this.sdkPackageName = sdkPackageName;
        this.sdkModule = sdkModule;
        this.resourceTablePackageIdRemapper = new ResourceTablePackageIdRemapper(dependencyConfig.getResourcesPackageId());
        this.xmlPackageIdRemapper = new XmlPackageIdRemapper(dependencyConfig.getResourcesPackageId());
        this.rPackageDexEntryRemover = new RPackageDexEntryRemover();
        this.dexAndResourceRepackager = new DexAndResourceRepackager(sdkModulesConfig);
    }

    public BundleModule convert() {
        return this.convertNameTypeAndManifest(this.repackageDexAndJavaResources(this.removeRPackageDexFile(this.remapResourceIdsInXmlResources(this.remapResourceIdsInResourceTable(this.sdkModule)))));
    }

    private BundleModule remapResourceIdsInResourceTable(BundleModule module) {
        return this.resourceTablePackageIdRemapper.remap(module);
    }

    private BundleModule remapResourceIdsInXmlResources(BundleModule module) {
        return this.xmlPackageIdRemapper.remap(module);
    }

    private BundleModule removeRPackageDexFile(BundleModule module) {
        return this.rPackageDexEntryRemover.applyMutation(module);
    }

    private BundleModule repackageDexAndJavaResources(BundleModule module) {
        return this.dexAndResourceRepackager.repackage(module);
    }

    private BundleModule convertNameTypeAndManifest(BundleModule module) {
        String sdkModuleName = this.sdkPackageName.replace(".", "");
        return module.toBuilder().setName(BundleModuleName.create(sdkModuleName)).setModuleType(BundleModule.ModuleType.SDK_DEPENDENCY_MODULE).setAndroidManifest(this.sdkModule.getAndroidManifest().toEditor().removeUsesSdkElement().setSplitIdForFeatureSplit(sdkModuleName).setDeliveryOptionsForRuntimeEnabledSdkModule().save()).build();
    }
}

