/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.bundle.DeviceGroup;
import com.android.bundle.DeviceSelector;
import com.android.bundle.DeviceTier;
import com.android.bundle.DeviceTierConfig;
import com.android.bundle.DeviceTierSet;
import com.android.tools.build.bundletool.model.exceptions.CommandExecutionException;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;

public class DeviceTierConfigValidator {
    private DeviceTierConfigValidator() {
    }

    public static void validateDeviceTierConfig(DeviceTierConfig deviceTierConfig) {
        DeviceTierConfigValidator.validateGroups(deviceTierConfig.getDeviceGroupsList());
        DeviceTierConfigValidator.validateTiers(deviceTierConfig.getDeviceTierSet(), deviceTierConfig.getDeviceGroupsList());
    }

    private static void validateGroups(List<DeviceGroup> deviceGroups) {
        if (deviceGroups.isEmpty()) {
            throw CommandExecutionException.builder().withInternalMessage("The device tier config must contain at least one group.").build();
        }
        for (DeviceGroup deviceGroup : deviceGroups) {
            if (deviceGroup.getName().isEmpty()) {
                throw CommandExecutionException.builder().withInternalMessage("Device groups must specify a name.").build();
            }
            DeviceTierConfigValidator.validateDeviceSelectors(deviceGroup.getDeviceSelectorsList(), deviceGroup.getName());
        }
    }

    private static void validateDeviceSelectors(List<DeviceSelector> deviceSelectors, String groupName) {
        if (deviceSelectors.isEmpty()) {
            throw CommandExecutionException.builder().withInternalMessage("Device group '%s' must specify at least one selector.", groupName).build();
        }
    }

    private static void validateTiers(DeviceTierSet deviceTierSet, List<DeviceGroup> deviceGroups) {
        if (deviceTierSet.getDeviceTiersCount() == 0) {
            return;
        }
        ImmutableSet deviceGroupNames = (ImmutableSet)deviceGroups.stream().map(DeviceGroup::getName).collect(ImmutableSet.toImmutableSet());
        DeviceTierConfigValidator.validateTierLevels(deviceTierSet);
        for (DeviceTier deviceTier : deviceTierSet.getDeviceTiersList()) {
            if (deviceTier.getDeviceGroupNamesList().isEmpty()) {
                throw CommandExecutionException.builder().withInternalMessage("Tier %d must specify at least one group", deviceTier.getLevel()).build();
            }
            for (String deviceGroupName : deviceTier.getDeviceGroupNamesList()) {
                if (deviceGroupNames.contains((Object)deviceGroupName)) continue;
                throw CommandExecutionException.builder().withInternalMessage("Tier %d must specify existing groups, but found undefined group '%s'.", deviceTier.getLevel(), deviceGroupName).build();
            }
        }
    }

    private static void validateTierLevels(DeviceTierSet deviceTierSet) {
        ImmutableListMultimap tiersByLevel = (ImmutableListMultimap)deviceTierSet.getDeviceTiersList().stream().collect(ImmutableListMultimap.toImmutableListMultimap(DeviceTier::getLevel, x11 -> x11));
        int minTierLevel = (Integer)Collections.min(tiersByLevel.keySet());
        int maxTierLevel = (Integer)Collections.max(tiersByLevel.keySet());
        if (minTierLevel <= 0) {
            throw CommandExecutionException.builder().withInternalMessage("Each tier must specify a positive level, but found %d.", minTierLevel).build();
        }
        for (int level = 1; level <= maxTierLevel; ++level) {
            if (!tiersByLevel.containsKey((Object)level)) {
                throw CommandExecutionException.builder().withInternalMessage("Tier %d is undefined. You should define all tiers between 1 and your total number of tiers.", level).build();
            }
            if (tiersByLevel.get((Object)level).size() <= 1) continue;
            throw CommandExecutionException.builder().withInternalMessage("Tier %d should be uniquely defined, but it was defined %d times.", level, tiersByLevel.get((Object)level).size()).build();
        }
    }
}

