/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.sdkmodule;

import com.android.aapt.Resources;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.utils.ResourcesUtils;
import com.google.common.base.Preconditions;

final class ResourceTablePackageIdRemapper {
    private final int newPackageId;

    ResourceTablePackageIdRemapper(int newPackageId) {
        this.newPackageId = newPackageId;
    }

    BundleModule remap(BundleModule module) {
        if (!module.getResourceTable().isPresent()) {
            return module;
        }
        Resources.ResourceTable resourceTable = module.getResourceTable().get();
        Preconditions.checkArgument((resourceTable.getPackageCount() <= 1 ? 1 : 0) != 0, (String)"Module '%s' contains resource table with %s 'package' entries, but only 1 entry is allowed.", (Object)module.getName().getName(), (int)resourceTable.getPackageCount());
        Resources.ResourceTable.Builder remappedResourceTable = resourceTable.toBuilder();
        remappedResourceTable.getPackageBuilderList().forEach(this::remapInPackage);
        return module.toBuilder().setResourceTable(remappedResourceTable.build()).build();
    }

    private void remapInPackage(Resources.Package.Builder resourceTablePackage) {
        resourceTablePackage.setPackageId(Resources.PackageId.newBuilder().setId(this.newPackageId)).getTypeBuilderList().forEach(this::remapInType);
    }

    private void remapInType(Resources.Type.Builder type) {
        type.getEntryBuilderList().forEach(this::remapInEntry);
    }

    private void remapInEntry(Resources.Entry.Builder entry) {
        entry.getConfigValueBuilderList().forEach(this::remapInConfigValue);
    }

    private void remapInConfigValue(Resources.ConfigValue.Builder configValue) {
        if (!configValue.hasValue()) {
            return;
        }
        this.remapInValue(configValue.getValueBuilder());
    }

    private void remapInValue(Resources.Value.Builder value) {
        if (value.hasItem()) {
            this.remapInItemValue(value);
        } else {
            this.remapInCompoundValue(value);
        }
    }

    private void remapInItemValue(Resources.Value.Builder value) {
        if (!value.hasItem()) {
            return;
        }
        this.remapInItem(value.getItemBuilder());
    }

    private void remapInItem(Resources.Item.Builder item) {
        if (!item.hasRef()) {
            return;
        }
        this.remapInReference(item.getRefBuilder());
    }

    private void remapInCompoundValue(Resources.Value.Builder value) {
        if (!value.hasCompoundValue()) {
            return;
        }
        this.remapInCompoundValue(value.getCompoundValueBuilder());
    }

    private void remapInCompoundValue(Resources.CompoundValue.Builder compoundValue) {
        switch (compoundValue.getValueCase()) {
            case ATTR: {
                this.remapInAttributeCompoundValue(compoundValue);
                break;
            }
            case STYLE: {
                this.remapInStyleCompoundValue(compoundValue);
                break;
            }
            case STYLEABLE: {
                this.remapInStylableCompoundValue(compoundValue);
                break;
            }
            case ARRAY: {
                this.remapInArrayCompoundValue(compoundValue);
                break;
            }
            case PLURAL: {
                this.remapInPluralCompoundValue(compoundValue);
                break;
            }
        }
    }

    private void remapInAttributeCompoundValue(Resources.CompoundValue.Builder compoundValue) {
        if (!compoundValue.hasAttr()) {
            return;
        }
        this.remapInAttribute(compoundValue.getAttrBuilder());
    }

    private void remapInStyleCompoundValue(Resources.CompoundValue.Builder compoundValue) {
        if (!compoundValue.hasStyle()) {
            return;
        }
        this.remapInStyle(compoundValue.getStyleBuilder());
    }

    private void remapInStylableCompoundValue(Resources.CompoundValue.Builder compoundValue) {
        if (!compoundValue.hasStyleable()) {
            return;
        }
        this.remapInStyleable(compoundValue.getStyleableBuilder());
    }

    private void remapInArrayCompoundValue(Resources.CompoundValue.Builder compoundValue) {
        if (!compoundValue.hasArray()) {
            return;
        }
        this.remapInArray(compoundValue.getArrayBuilder());
    }

    private void remapInPluralCompoundValue(Resources.CompoundValue.Builder compoundValue) {
        if (!compoundValue.hasPlural()) {
            return;
        }
        this.remapInPlural(compoundValue.getPluralBuilder());
    }

    private void remapInAttribute(Resources.Attribute.Builder attribute) {
        attribute.getSymbolBuilderList().forEach(this::remapInSymbol);
    }

    private void remapInSymbol(Resources.Attribute.Symbol.Builder symbol) {
        if (!symbol.hasName()) {
            return;
        }
        this.remapInReference(symbol.getNameBuilder());
    }

    private void remapInStyle(Resources.Style.Builder style) {
        if (style.hasParent()) {
            this.remapInReference(style.getParentBuilder());
        }
        style.getEntryBuilderList().forEach(this::remapInStyleEntry);
    }

    private void remapInStyleable(Resources.Styleable.Builder styleable) {
        styleable.getEntryBuilderList().forEach(this::remapInStyleableEntry);
    }

    private void remapInArray(Resources.Array.Builder array) {
        array.getElementBuilderList().forEach(this::remapInArrayElement);
    }

    private void remapInPlural(Resources.Plural.Builder plural) {
        plural.getEntryBuilderList().forEach(this::remapInPluralEntry);
    }

    private void remapInStyleEntry(Resources.Style.Entry.Builder styleEntry) {
        if (!styleEntry.hasKey()) {
            return;
        }
        this.remapInReference(styleEntry.getKeyBuilder());
    }

    private void remapInStyleableEntry(Resources.Styleable.Entry.Builder styleableEntry) {
        if (!styleableEntry.hasAttr()) {
            return;
        }
        this.remapInReference(styleableEntry.getAttrBuilder());
    }

    private void remapInArrayElement(Resources.Array.Element.Builder element) {
        if (!element.hasItem()) {
            return;
        }
        this.remapInItem(element.getItemBuilder());
    }

    private void remapInPluralEntry(Resources.Plural.Entry.Builder entry) {
        if (!entry.hasItem()) {
            return;
        }
        this.remapInItem(entry.getItemBuilder());
    }

    private void remapInReference(Resources.Reference.Builder reference) {
        reference.setId(ResourcesUtils.remapPackageIdInResourceId(reference.getId(), this.newPackageId));
    }
}

