/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.shards;

import com.android.bundle.Config;
import com.android.bundle.Files;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.targeting.TargetedDirectory;
import com.android.tools.build.bundletool.model.targeting.TargetedDirectorySegment;
import com.android.tools.build.bundletool.model.targeting.TargetingDimension;
import com.android.tools.build.bundletool.model.utils.TextureCompressionUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.protobuf.Int32Value;
import java.util.List;

public final class SuffixStripper {
    private final TargetingDimension targetingDimension;
    private final TargetingDimensionHandler dimensionHandler;

    public static SuffixStripper createForDimension(Config.SplitDimension.Value dimension) {
        switch (dimension) {
            case TEXTURE_COMPRESSION_FORMAT: {
                return SuffixStripper.createForDimension(TargetingDimension.TEXTURE_COMPRESSION_FORMAT);
            }
            case DEVICE_TIER: {
                return SuffixStripper.createForDimension(TargetingDimension.DEVICE_TIER);
            }
            case COUNTRY_SET: {
                return SuffixStripper.createForDimension(TargetingDimension.COUNTRY_SET);
            }
        }
        throw new IllegalArgumentException("Cannot strip suffixes for dimension " + (Object)((Object)dimension));
    }

    public static SuffixStripper createForDimension(TargetingDimension dimension) {
        switch (dimension) {
            case TEXTURE_COMPRESSION_FORMAT: {
                return new SuffixStripper(dimension, new TextureCompressionFormatDimensionHandler());
            }
            case DEVICE_TIER: {
                return new SuffixStripper(dimension, new DeviceTierDimensionHandler());
            }
            case COUNTRY_SET: {
                return new SuffixStripper(dimension, new CountrySetDimensionHandler());
            }
        }
        throw new IllegalArgumentException("Cannot strip suffixes for dimension " + (Object)((Object)dimension));
    }

    private SuffixStripper(TargetingDimension dimension, TargetingDimensionHandler dimensionHandler) {
        this.targetingDimension = dimension;
        this.dimensionHandler = dimensionHandler;
    }

    public ModuleSplit applySuffixStripping(ModuleSplit split, Config.SuffixStripping suffixStripping) {
        split = this.excludeAssetsTargetingOtherValue(split, suffixStripping.getDefaultSuffix());
        if (suffixStripping.getEnabled()) {
            split = this.removeAssetsTargeting(split);
        }
        split = this.setTargetingByDefaultSuffix(split, suffixStripping.getDefaultSuffix());
        return split;
    }

    private ModuleSplit setTargetingByDefaultSuffix(ModuleSplit moduleSplit, String value) {
        if (value.isEmpty()) {
            return moduleSplit;
        }
        return moduleSplit.toBuilder().setApkTargeting(this.dimensionHandler.setTargetingDimension(moduleSplit.getApkTargeting(), value)).setVariantTargeting(this.dimensionHandler.setTargetingDimension(moduleSplit.getVariantTargeting(), value)).build();
    }

    public ModuleSplit removeAssetsTargeting(ModuleSplit moduleSplit) {
        if (!moduleSplit.getAssetsConfig().isPresent()) {
            return moduleSplit;
        }
        Files.Assets assetsConfig = moduleSplit.getAssetsConfig().get();
        Files.Assets.Builder updatedAssetsConfig = assetsConfig.toBuilder().clearDirectory();
        ImmutableList updatedEntries = moduleSplit.getEntries();
        for (Files.TargetedAssetsDirectory targetedAssetsDirectory : assetsConfig.getDirectoryList()) {
            Files.TargetedAssetsDirectory updatedTargetedAssetsDirectory = this.removeAssetsTargetingFromDirectory(targetedAssetsDirectory);
            if (!updatedTargetedAssetsDirectory.equals(targetedAssetsDirectory)) {
                ZipPath directoryPath = ZipPath.create(targetedAssetsDirectory.getPath());
                updatedEntries = (ImmutableList)updatedEntries.stream().map(entry -> {
                    if (entry.getPath().startsWith(directoryPath)) {
                        return this.removeTargetingFromEntry((ModuleEntry)entry);
                    }
                    return entry;
                }).collect(ImmutableList.toImmutableList());
            }
            updatedAssetsConfig.addDirectory(updatedTargetedAssetsDirectory);
        }
        return moduleSplit.toBuilder().setEntries((List<ModuleEntry>)updatedEntries).setAssetsConfig(updatedAssetsConfig.build()).build();
    }

    private ModuleSplit excludeAssetsTargetingOtherValue(ModuleSplit moduleSplit, String value) {
        if (!moduleSplit.getAssetsConfig().isPresent()) {
            return moduleSplit;
        }
        Files.Assets assetsConfig = moduleSplit.getAssetsConfig().get();
        Files.Assets.Builder updatedAssetsConfig = assetsConfig.toBuilder().clearDirectory();
        ImmutableList updatedEntries = moduleSplit.getEntries();
        for (Files.TargetedAssetsDirectory targetedAssetsDirectory : assetsConfig.getDirectoryList()) {
            ZipPath directoryPath = ZipPath.create(targetedAssetsDirectory.getPath());
            if (this.dimensionHandler.isDirectoryTargetingOtherValue(targetedAssetsDirectory, value)) {
                updatedEntries = (ImmutableList)updatedEntries.stream().filter(entry -> !entry.getPath().startsWith(directoryPath)).collect(ImmutableList.toImmutableList());
                continue;
            }
            updatedAssetsConfig.addDirectory(targetedAssetsDirectory);
        }
        return moduleSplit.toBuilder().setEntries((List<ModuleEntry>)updatedEntries).setAssetsConfig(updatedAssetsConfig.build()).build();
    }

    private Files.TargetedAssetsDirectory removeAssetsTargetingFromDirectory(Files.TargetedAssetsDirectory directory) {
        if (!this.dimensionHandler.hasTargetingDimension(directory.getTargeting())) {
            return directory;
        }
        TargetedDirectory targetedDirectory = TargetedDirectory.parse(ZipPath.create(directory.getPath()));
        TargetedDirectory newTargetedDirectory = targetedDirectory.removeTargeting(this.targetingDimension);
        return directory.toBuilder().setPath(newTargetedDirectory.toZipPath().toString()).setTargeting(this.dimensionHandler.clearTargetingDimension(directory.getTargeting())).build();
    }

    private ModuleEntry removeTargetingFromEntry(ModuleEntry moduleEntry) {
        if (!TargetedDirectorySegment.pathMayContain(moduleEntry.getPath().toString(), this.targetingDimension)) {
            return moduleEntry;
        }
        TargetedDirectory targetedDirectory = TargetedDirectory.parse(moduleEntry.getPath());
        TargetedDirectory newTargetedDirectory = targetedDirectory.removeTargeting(this.targetingDimension);
        if (!newTargetedDirectory.equals(targetedDirectory)) {
            return moduleEntry.toBuilder().setPath(newTargetedDirectory.toZipPath()).build();
        }
        return moduleEntry;
    }

    private static final class TextureCompressionFormatDimensionHandler
    implements TargetingDimensionHandler {
        private TextureCompressionFormatDimensionHandler() {
        }

        @Override
        public boolean hasTargetingDimension(Targeting.AssetsDirectoryTargeting directoryTargeting) {
            return directoryTargeting.hasTextureCompressionFormat();
        }

        @Override
        public Targeting.AssetsDirectoryTargeting clearTargetingDimension(Targeting.AssetsDirectoryTargeting directoryTargeting) {
            return directoryTargeting.toBuilder().clearTextureCompressionFormat().build();
        }

        @Override
        public Targeting.ApkTargeting setTargetingDimension(Targeting.ApkTargeting apkTargeting, String value) {
            return apkTargeting.toBuilder().setTextureCompressionFormatTargeting((Targeting.TextureCompressionFormatTargeting)TextureCompressionUtils.TEXTURE_TO_TARGETING.get((Object)value)).build();
        }

        @Override
        public Targeting.VariantTargeting setTargetingDimension(Targeting.VariantTargeting variantTargeting, String value) {
            return variantTargeting.toBuilder().setTextureCompressionFormatTargeting((Targeting.TextureCompressionFormatTargeting)TextureCompressionUtils.TEXTURE_TO_TARGETING.get((Object)value)).build();
        }

        @Override
        public boolean isDirectoryTargetingOtherValue(Files.TargetedAssetsDirectory directory, String searchedValue) {
            Targeting.AssetsDirectoryTargeting targeting = directory.getTargeting();
            if (!targeting.hasTextureCompressionFormat()) {
                return false;
            }
            boolean isDirectoryValueFallback = targeting.getTextureCompressionFormat().getValueList().isEmpty();
            boolean isSearchedValueFallback = searchedValue.isEmpty();
            if (isSearchedValueFallback || isDirectoryValueFallback) {
                return isSearchedValueFallback != isDirectoryValueFallback;
            }
            String targetingValue = (String)TextureCompressionUtils.TARGETING_TO_TEXTURE.getOrDefault((Object)((Targeting.TextureCompressionFormat)Iterables.getOnlyElement(targeting.getTextureCompressionFormat().getValueList())).getAlias(), null);
            return !searchedValue.equals(targetingValue);
        }
    }

    private static interface TargetingDimensionHandler {
        public boolean hasTargetingDimension(Targeting.AssetsDirectoryTargeting var1);

        public Targeting.AssetsDirectoryTargeting clearTargetingDimension(Targeting.AssetsDirectoryTargeting var1);

        public Targeting.ApkTargeting setTargetingDimension(Targeting.ApkTargeting var1, String var2);

        public Targeting.VariantTargeting setTargetingDimension(Targeting.VariantTargeting var1, String var2);

        public boolean isDirectoryTargetingOtherValue(Files.TargetedAssetsDirectory var1, String var2);
    }

    private static final class DeviceTierDimensionHandler
    implements TargetingDimensionHandler {
        private DeviceTierDimensionHandler() {
        }

        @Override
        public boolean hasTargetingDimension(Targeting.AssetsDirectoryTargeting directoryTargeting) {
            return directoryTargeting.hasDeviceTier();
        }

        @Override
        public Targeting.AssetsDirectoryTargeting clearTargetingDimension(Targeting.AssetsDirectoryTargeting directoryTargeting) {
            return directoryTargeting.toBuilder().clearDeviceTier().build();
        }

        @Override
        public Targeting.ApkTargeting setTargetingDimension(Targeting.ApkTargeting apkTargeting, String value) {
            return apkTargeting.toBuilder().setDeviceTierTargeting(Targeting.DeviceTierTargeting.newBuilder().addValue(Int32Value.of((int)Integer.parseInt(value)))).build();
        }

        @Override
        public Targeting.VariantTargeting setTargetingDimension(Targeting.VariantTargeting variantTargeting, String value) {
            return variantTargeting;
        }

        @Override
        public boolean isDirectoryTargetingOtherValue(Files.TargetedAssetsDirectory directory, String searchedValue) {
            Targeting.AssetsDirectoryTargeting targeting = directory.getTargeting();
            if (!targeting.hasDeviceTier()) {
                return false;
            }
            String searchedValueWithDefault = searchedValue.isEmpty() ? "0" : searchedValue;
            String targetingValue = Integer.toString(((Int32Value)Iterables.getOnlyElement(targeting.getDeviceTier().getValueList())).getValue());
            return !searchedValueWithDefault.equals(targetingValue);
        }
    }

    private static final class CountrySetDimensionHandler
    implements TargetingDimensionHandler {
        private CountrySetDimensionHandler() {
        }

        @Override
        public boolean hasTargetingDimension(Targeting.AssetsDirectoryTargeting directoryTargeting) {
            return directoryTargeting.hasCountrySet();
        }

        @Override
        public Targeting.AssetsDirectoryTargeting clearTargetingDimension(Targeting.AssetsDirectoryTargeting directoryTargeting) {
            return directoryTargeting.toBuilder().clearCountrySet().build();
        }

        @Override
        public Targeting.ApkTargeting setTargetingDimension(Targeting.ApkTargeting apkTargeting, String value) {
            return apkTargeting.toBuilder().setCountrySetTargeting(Targeting.CountrySetTargeting.newBuilder().addValue(value)).build();
        }

        @Override
        public Targeting.VariantTargeting setTargetingDimension(Targeting.VariantTargeting variantTargeting, String value) {
            return variantTargeting;
        }

        @Override
        public boolean isDirectoryTargetingOtherValue(Files.TargetedAssetsDirectory directory, String searchedValue) {
            Targeting.AssetsDirectoryTargeting targeting = directory.getTargeting();
            if (!targeting.hasCountrySet()) {
                return false;
            }
            String targetingValue = (String)Iterables.getOnlyElement((Iterable)targeting.getCountrySet().getValueList(), (Object)"");
            return !searchedValue.equals(targetingValue);
        }
    }
}

