/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.ddmlib.logcat;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import shadow.bundletool.com.android.ddmlib.IDevice;
import shadow.bundletool.com.android.ddmlib.Log;
import shadow.bundletool.com.android.ddmlib.logcat.LogCatHeader;

public class LogCatHeaderParser {
    private static final Pattern EPOCH = Pattern.compile("(?<epoch>(?<epochSec>\\d+)\\.(?<epochMilli>\\d\\d\\d))");
    private static final Pattern DATE = Pattern.compile("(?<month>\\d\\d)-(?<day>\\d\\d)");
    private static final Pattern TIME = Pattern.compile("(?<hour>\\d\\d):(?<min>\\d\\d):(?<sec>\\d\\d)\\.(?<milli>\\d\\d\\d)");
    private static final Pattern PID = Pattern.compile("(?<pid>\\d+)");
    private static final Pattern TID = Pattern.compile("(?<tid>\\w+)");
    private static final Pattern PRIORITY = Pattern.compile("(?<priority>[VDIWEAF])");
    private static final Pattern TAG = Pattern.compile("(?<tag>.*?)");
    private static final String UNKNOWN_APP_NAME = "?";
    private static final Pattern HEADER = Pattern.compile(String.format("^\\[ +((%s +%s)|(%s)) +%s: *%s +%s/%s +]$", DATE, TIME, EPOCH, PID, TID, PRIORITY, TAG));
    private final int defaultYear;
    private final ZoneId defaultZoneId;

    public LogCatHeaderParser() {
        this(ZonedDateTime.now().getYear(), ZoneId.systemDefault());
    }

    public LogCatHeaderParser(int year, ZoneId id2) {
        this.defaultYear = year;
        this.defaultZoneId = id2;
    }

    public LogCatHeader parseHeader(String line, IDevice device) {
        return this.parseHeader(line, (int pid) -> this.getPackageName(device, pid));
    }

    public LogCatHeader parseHeader(String line, PidToPackageName pidToPackageName) {
        Matcher m11 = HEADER.matcher(line);
        if (!m11.matches()) {
            return null;
        }
        String epoch = m11.group("epoch");
        Instant timestamp = epoch != null ? Instant.ofEpochSecond(this.parseEpochSeconds(m11.group("epochSec")), TimeUnit.MILLISECONDS.toNanos(Long.parseLong(m11.group("epochMilli")))) : Instant.from(ZonedDateTime.of(this.defaultYear, Integer.parseInt(m11.group("month")), Integer.parseInt(m11.group("day")), Integer.parseInt(m11.group("hour")), Integer.parseInt(m11.group("min")), Integer.parseInt(m11.group("sec")), (int)TimeUnit.MILLISECONDS.toNanos(Long.parseLong(m11.group("milli"))), this.defaultZoneId));
        int pid = this.parsePid(m11.group("pid"));
        return new LogCatHeader(this.parsePriority(m11.group("priority")), pid, this.parseThreadId(m11.group("tid")), pidToPackageName.apply(pid), m11.group("tag"), timestamp);
    }

    private Log.LogLevel parsePriority(String string) {
        Log.LogLevel priority = Log.LogLevel.getByLetterString(string);
        if (priority != null) {
            return priority;
        }
        if (!string.equals("F")) {
            return Log.LogLevel.WARN;
        }
        return Log.LogLevel.ASSERT;
    }

    private int parseThreadId(String string) {
        try {
            return Integer.decode(string);
        }
        catch (NumberFormatException exception) {
            return -1;
        }
    }

    private int parsePid(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException exception) {
            return -1;
        }
    }

    private long parseEpochSeconds(String string) {
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException exception) {
            return 0L;
        }
    }

    private String getPackageName(IDevice device, int pid) {
        if (device == null) {
            return UNKNOWN_APP_NAME;
        }
        String clientName = device.getClientName(pid);
        if (clientName == null || clientName.isEmpty()) {
            return UNKNOWN_APP_NAME;
        }
        return clientName;
    }

    @FunctionalInterface
    public static interface PidToPackageName {
        public String apply(int var1);
    }
}

