/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.splitters;

import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.targeting.TargetingUtils;
import com.android.tools.build.bundletool.splitters.ApkGenerationConfiguration;
import com.android.tools.build.bundletool.splitters.PerModuleVariantTargetingGenerator;
import com.android.tools.build.bundletool.splitters.SdkRuntimeVariantGenerator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import javax.inject.Inject;

public class VariantTargetingGenerator {
    private final PerModuleVariantTargetingGenerator perModuleVariantTargetingGenerator;
    private final SdkRuntimeVariantGenerator sdkRuntimeVariantGenerator;

    @Inject
    VariantTargetingGenerator(PerModuleVariantTargetingGenerator perModuleVariantTargetingGenerator, SdkRuntimeVariantGenerator sdkRuntimeVariantGenerator) {
        this.perModuleVariantTargetingGenerator = perModuleVariantTargetingGenerator;
        this.sdkRuntimeVariantGenerator = sdkRuntimeVariantGenerator;
    }

    public ImmutableSet<Targeting.VariantTargeting> generateVariantTargetings(ImmutableList<BundleModule> modules, ApkGenerationConfiguration apkGenerationConfiguration) {
        ImmutableSet<Targeting.VariantTargeting> nonSdkRuntimeVariantTargetings = this.generateNonSdkRuntimeVariantTargetings(modules, apkGenerationConfiguration);
        ImmutableSet<Targeting.VariantTargeting> sdkRuntimeVariantTargetings = this.sdkRuntimeVariantGenerator.generate(nonSdkRuntimeVariantTargetings);
        return ImmutableSet.builder().addAll(nonSdkRuntimeVariantTargetings).addAll(sdkRuntimeVariantTargetings).build();
    }

    private ImmutableSet<Targeting.VariantTargeting> generateNonSdkRuntimeVariantTargetings(ImmutableList<BundleModule> modules, ApkGenerationConfiguration apkGenerationConfiguration) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (BundleModule module : modules) {
            ImmutableSet<Targeting.VariantTargeting> variantTargetings = this.perModuleVariantTargetingGenerator.generateVariants(module, apkGenerationConfiguration);
            builder.addAll(variantTargetings);
        }
        return TargetingUtils.generateAllVariantTargetings((ImmutableSet<Targeting.VariantTargeting>)builder.build());
    }
}

