/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.androidtools;

import com.android.tools.build.bundletool.androidtools.CommandExecutor;
import com.android.tools.build.bundletool.model.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.model.utils.files.BufferedIo;
import com.google.common.collect.ImmutableList;
import com.google.common.io.LineReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class DefaultCommandExecutor
implements CommandExecutor {
    @Override
    public void execute(ImmutableList<String> command, CommandExecutor.CommandOptions options) {
        ImmutableList<String> capturedOutput = DefaultCommandExecutor.executeImpl(command, options);
        DefaultCommandExecutor.printOutput(capturedOutput, System.out);
    }

    @Override
    public ImmutableList<String> executeAndCapture(ImmutableList<String> command, CommandExecutor.CommandOptions options) {
        return DefaultCommandExecutor.executeImpl(command, options);
    }

    private static ImmutableList<String> executeImpl(ImmutableList<String> command, CommandExecutor.CommandOptions options) {
        try {
            Process process = new ProcessBuilder((List<String>)command).redirectOutput(ProcessBuilder.Redirect.PIPE).redirectErrorStream(true).start();
            OutputCapturer outputCapturer = OutputCapturer.startCapture(process.getInputStream());
            if (!process.waitFor(options.getTimeout().toMillis(), TimeUnit.MILLISECONDS)) {
                DefaultCommandExecutor.printOutput(outputCapturer.getOutput(true), System.err);
                throw CommandExecutionException.builder().withInternalMessage("Command timed out: %s", command).build();
            }
            if (process.exitValue() != 0) {
                DefaultCommandExecutor.printOutput(outputCapturer.getOutput(true), System.err);
                throw CommandExecutionException.builder().withInternalMessage("Command '%s' didn't terminate successfully (exit code: %d). Check the logs.", command, process.exitValue()).build();
            }
            return outputCapturer.getOutput(false);
        }
        catch (IOException | InterruptedException e11) {
            throw CommandExecutionException.builder().withInternalMessage("Error when executing command: %s", command).withCause(e11).build();
        }
    }

    private static void printOutput(List<String> output, PrintStream stream) {
        for (String line : output) {
            stream.println(line);
        }
    }

    static class OutputCapturer {
        private final Thread thread;
        private final List<String> output;
        private final InputStream stream;

        private OutputCapturer(Thread thread, List<String> output, InputStream stream) {
            this.thread = thread;
            this.output = output;
            this.stream = stream;
        }

        static OutputCapturer startCapture(InputStream stream) {
            ArrayList<String> output = new ArrayList<String>();
            Thread thread = new Thread(() -> {
                try (BufferedReader reader = BufferedIo.reader(stream);){
                    String line;
                    LineReader lineReader = new LineReader((Readable)reader);
                    while ((line = lineReader.readLine()) != null) {
                        output.add(line);
                    }
                }
                catch (IOException e11) {
                    throw new UncheckedIOException(e11);
                }
            });
            thread.start();
            return new OutputCapturer(thread, output, stream);
        }

        ImmutableList<String> getOutput(boolean interrupt) throws InterruptedException, IOException {
            if (interrupt) {
                this.stream.close();
            }
            this.thread.join();
            return ImmutableList.copyOf(this.output);
        }
    }
}

