/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model.utils.files;

import com.google.errorprone.annotations.MustBeClosed;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.annotation.WillCloseWhenClosed;

public final class BufferedIo {
    @MustBeClosed
    public static BufferedReader reader(@WillCloseWhenClosed InputStream is2) {
        return new BufferedReader(new InputStreamReader(is2, StandardCharsets.UTF_8));
    }

    @MustBeClosed
    public static BufferedReader reader(Path file2) throws IOException {
        return Files.newBufferedReader(file2, StandardCharsets.UTF_8);
    }

    @MustBeClosed
    public static InputStream inputStream(Path file2) throws IOException {
        return BufferedIo.makeBuffered(Files.newInputStream(file2, new OpenOption[0]));
    }

    @MustBeClosed
    public static OutputStream outputStream(Path file2) throws IOException {
        return BufferedIo.makeBuffered(Files.newOutputStream(file2, new OpenOption[0]));
    }

    @MustBeClosed
    static InputStream makeBuffered(@WillCloseWhenClosed InputStream is2) {
        return is2 instanceof BufferedInputStream || is2 instanceof ByteArrayInputStream ? is2 : new BufferedInputStream(is2);
    }

    @MustBeClosed
    static OutputStream makeBuffered(@WillCloseWhenClosed OutputStream os2) {
        return os2 instanceof BufferedOutputStream || os2 instanceof ByteArrayOutputStream ? os2 : new BufferedOutputStream(os2);
    }

    private BufferedIo() {
    }
}

