/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.bundle.Config;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.utils.BundleModuleParser;
import com.android.tools.build.bundletool.validation.AbiParityValidator;
import com.android.tools.build.bundletool.validation.AndroidManifestValidator;
import com.android.tools.build.bundletool.validation.ApexBundleValidator;
import com.android.tools.build.bundletool.validation.AssetBundleValidator;
import com.android.tools.build.bundletool.validation.AssetModuleFilesValidator;
import com.android.tools.build.bundletool.validation.BundleFilesValidator;
import com.android.tools.build.bundletool.validation.CountrySetParityValidator;
import com.android.tools.build.bundletool.validation.DeviceGroupParityValidator;
import com.android.tools.build.bundletool.validation.DeviceTierParityValidator;
import com.android.tools.build.bundletool.validation.DexFilesValidator;
import com.android.tools.build.bundletool.validation.EntryClashValidator;
import com.android.tools.build.bundletool.validation.MandatoryFilesPresenceValidator;
import com.android.tools.build.bundletool.validation.ModuleDependencyValidator;
import com.android.tools.build.bundletool.validation.ModuleNamesValidator;
import com.android.tools.build.bundletool.validation.ModuleTitleValidator;
import com.android.tools.build.bundletool.validation.NestedTargetingValidator;
import com.android.tools.build.bundletool.validation.ResourceTableValidator;
import com.android.tools.build.bundletool.validation.SubValidator;
import com.android.tools.build.bundletool.validation.TextureCompressionFormatParityValidator;
import com.android.tools.build.bundletool.validation.ValidatorRunner;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.zip.ZipFile;

public class BundleModulesValidator {
    @VisibleForTesting
    static final ImmutableList<SubValidator> MODULE_FILE_SUB_VALIDATORS = ImmutableList.of((Object)new MandatoryFilesPresenceValidator(AppBundle.NON_MODULE_DIRECTORIES));
    @VisibleForTesting
    static final ImmutableList<SubValidator> MODULES_SUB_VALIDATORS = ImmutableList.of((Object)new BundleFilesValidator(), (Object)new ModuleNamesValidator(), (Object)new AndroidManifestValidator(), (Object)new EntryClashValidator(), (Object)new NestedTargetingValidator(), (Object)new AbiParityValidator(), (Object)new TextureCompressionFormatParityValidator(), (Object)new DeviceGroupParityValidator(), (Object)new DeviceTierParityValidator(), (Object)new CountrySetParityValidator(), (Object)new DexFilesValidator(), (Object)new ApexBundleValidator(), (Object[])new SubValidator[]{new AssetBundleValidator(), new ModuleDependencyValidator(), new ModuleTitleValidator(), new ResourceTableValidator(), new AssetModuleFilesValidator()});

    public ImmutableList<BundleModule> validate(ImmutableList<ZipFile> moduleZips, Config.BundleConfig bundleConfig) {
        for (ZipFile moduleZip : moduleZips) {
            new ValidatorRunner(MODULE_FILE_SUB_VALIDATORS).validateModuleZipFile(moduleZip);
        }
        ImmutableList modules = (ImmutableList)moduleZips.stream().map(module -> BundleModuleParser.parseAppBundleModule(module, bundleConfig)).collect(ImmutableList.toImmutableList());
        new ValidatorRunner(MODULES_SUB_VALIDATORS).validateBundleModules((ImmutableList<BundleModule>)modules);
        return modules;
    }
}

