/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.ddmlib.internal;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.concurrent.TimeUnit;
import shadow.bundletool.com.android.ddmlib.AndroidDebugBridge;
import shadow.bundletool.com.android.ddmlib.Client;
import shadow.bundletool.com.android.ddmlib.ClientData;
import shadow.bundletool.com.android.ddmlib.DDMLibJdwpTracer;
import shadow.bundletool.com.android.ddmlib.DdmPreferences;
import shadow.bundletool.com.android.ddmlib.DebugViewDumpHandler;
import shadow.bundletool.com.android.ddmlib.IDevice;
import shadow.bundletool.com.android.ddmlib.JdwpHandshake;
import shadow.bundletool.com.android.ddmlib.JdwpProcessor;
import shadow.bundletool.com.android.ddmlib.JdwpTrafficResponse;
import shadow.bundletool.com.android.ddmlib.Log;
import shadow.bundletool.com.android.ddmlib.internal.Debugger;
import shadow.bundletool.com.android.ddmlib.internal.DeviceImpl;
import shadow.bundletool.com.android.ddmlib.internal.MonitorThread;
import shadow.bundletool.com.android.ddmlib.internal.jdwp.chunkhandler.HandleExit;
import shadow.bundletool.com.android.ddmlib.internal.jdwp.chunkhandler.HandleHeap;
import shadow.bundletool.com.android.ddmlib.internal.jdwp.chunkhandler.HandleHello;
import shadow.bundletool.com.android.ddmlib.internal.jdwp.chunkhandler.HandleNativeHeap;
import shadow.bundletool.com.android.ddmlib.internal.jdwp.chunkhandler.HandleProfiling;
import shadow.bundletool.com.android.ddmlib.internal.jdwp.chunkhandler.HandleThread;
import shadow.bundletool.com.android.ddmlib.internal.jdwp.chunkhandler.HandleViewDebug;
import shadow.bundletool.com.android.ddmlib.internal.jdwp.chunkhandler.JdwpPacket;
import shadow.bundletool.com.android.ddmlib.jdwp.JdwpPipe;
import shadow.bundletool.com.android.ddmlib.jdwp.JdwpProtocol;

public class ClientImpl
extends JdwpPipe
implements Client {
    private volatile SocketChannel mChan;
    private Debugger mDebugger;
    private ClientData mClientData;
    private boolean mThreadUpdateEnabled;
    private boolean mHeapInfoUpdateEnabled;
    private boolean mHeapSegmentUpdateEnabled;
    private static final int INITIAL_BUF_SIZE = 2048;
    private ByteBuffer mReadBuffer;
    private final int mMaxPacketSize = DdmPreferences.getJdwpMaxPacketSize();
    private DeviceImpl mDevice;
    private int mConnState;
    private static final int ST_INIT = 1;
    private static final int ST_NOT_JDWP = 2;
    private static final int ST_AWAIT_SHAKE = 10;
    private static final int ST_NEED_DDM_PKT = 11;
    private static final int ST_NOT_DDM = 12;
    private static final int ST_READY = 13;
    private static final int ST_ERROR = 20;
    private static final int ST_DISCONNECTED = 21;
    private final DDMLibJdwpTracer jdwpTracer;
    private final JdwpProcessor scache;

    public ClientImpl(DeviceImpl device, SocketChannel chan, int pid) {
        super(new JdwpProtocol());
        this.mDevice = device;
        this.mChan = chan;
        this.mReadBuffer = ByteBuffer.allocate(2048);
        this.mConnState = 1;
        this.mClientData = new ClientData(this, pid);
        this.mThreadUpdateEnabled = DdmPreferences.getInitialThreadUpdate();
        this.mHeapInfoUpdateEnabled = DdmPreferences.getInitialHeapUpdate();
        this.mHeapSegmentUpdateEnabled = DdmPreferences.getInitialHeapUpdate();
        this.jdwpTracer = AndroidDebugBridge.newJdwpTracer();
        this.scache = AndroidDebugBridge.newProcessor();
    }

    public String toString() {
        return "[Client pid: " + this.mClientData.getPid() + "]";
    }

    @Override
    public IDevice getDevice() {
        return this.mDevice;
    }

    public DeviceImpl getDeviceImpl() {
        return this.mDevice;
    }

    @Override
    public int getDebuggerListenPort() {
        return this.getDebugger() == null ? -1 : this.getDebugger().getListenPort();
    }

    @Override
    public boolean isDdmAware() {
        switch (this.mConnState) {
            case 1: 
            case 2: 
            case 10: 
            case 11: 
            case 12: 
            case 20: 
            case 21: {
                return false;
            }
            case 13: {
                return true;
            }
        }
        assert (false);
        return false;
    }

    @Override
    public boolean isDebuggerAttached() {
        return this.mDebugger != null && this.mDebugger.isDebuggerAttached();
    }

    Debugger getDebugger() {
        return this.mDebugger;
    }

    @Override
    public ClientData getClientData() {
        return this.mClientData;
    }

    @Override
    public void executeGarbageCollector() {
        try {
            HandleHeap.sendHPGC(this);
        }
        catch (IOException ioe) {
            Log.w("ddms", "Send of HPGC message failed");
        }
    }

    @Deprecated
    public void toggleMethodProfiling() {
        try {
            switch (this.mClientData.getMethodProfilingStatus()) {
                case TRACER_ON: {
                    this.stopMethodTracer();
                    break;
                }
                case SAMPLER_ON: {
                    this.stopSamplingProfiler();
                    break;
                }
                case OFF: {
                    this.startMethodTracer();
                }
            }
        }
        catch (IOException e11) {
            Log.w("ddms", "Toggle method profiling failed");
        }
    }

    private static int getProfileBufferSize() {
        return DdmPreferences.getProfilerBufferSizeMb() * 1024 * 1024;
    }

    @Override
    public void startMethodTracer() throws IOException {
        boolean canStream = this.mClientData.hasFeature("method-trace-profiling-streaming");
        int bufferSize = ClientImpl.getProfileBufferSize();
        if (canStream) {
            HandleProfiling.sendMPSS(this, bufferSize, 0);
        } else {
            String file2 = "/sdcard/" + this.mClientData.getClientDescription().replaceAll("\\:.*", "") + ".trace";
            HandleProfiling.sendMPRS(this, file2, bufferSize, 0);
        }
    }

    @Override
    public void stopMethodTracer() throws IOException {
        boolean canStream = this.mClientData.hasFeature("method-trace-profiling-streaming");
        if (canStream) {
            HandleProfiling.sendMPSE(this);
        } else {
            HandleProfiling.sendMPRE(this);
        }
    }

    @Override
    public void startSamplingProfiler(int samplingInterval, TimeUnit timeUnit) throws IOException {
        int bufferSize = ClientImpl.getProfileBufferSize();
        HandleProfiling.sendSPSS(this, bufferSize, samplingInterval, timeUnit);
    }

    @Override
    public void stopSamplingProfiler() throws IOException {
        HandleProfiling.sendSPSE(this);
    }

    public boolean startOpenGlTracing() {
        boolean canTraceOpenGl = this.mClientData.hasFeature("opengl-tracing");
        if (!canTraceOpenGl) {
            return false;
        }
        try {
            HandleViewDebug.sendStartGlTracing(this);
            return true;
        }
        catch (IOException e11) {
            Log.w("ddms", "Start OpenGL Tracing failed");
            return false;
        }
    }

    public boolean stopOpenGlTracing() {
        boolean canTraceOpenGl = this.mClientData.hasFeature("opengl-tracing");
        if (!canTraceOpenGl) {
            return false;
        }
        try {
            HandleViewDebug.sendStopGlTracing(this);
            return true;
        }
        catch (IOException e11) {
            Log.w("ddms", "Stop OpenGL Tracing failed");
            return false;
        }
    }

    public void requestMethodProfilingStatus() {
        try {
            HandleHeap.sendREAQ(this);
        }
        catch (IOException e11) {
            Log.e("ddmlib", e11);
        }
    }

    public void setThreadUpdateEnabled(boolean enabled) {
        this.mThreadUpdateEnabled = enabled;
        if (!enabled) {
            this.mClientData.clearThreads();
        }
        try {
            HandleThread.sendTHEN(this, enabled);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.update(8);
    }

    public boolean isThreadUpdateEnabled() {
        return this.mThreadUpdateEnabled;
    }

    public void requestThreadUpdate() {
        HandleThread.requestThreadUpdate(this);
    }

    public void requestThreadStackTrace(int threadId) {
        HandleThread.requestThreadStackCallRefresh(this, threadId);
    }

    public void setHeapUpdateEnabled(boolean enabled) {
        this.setHeapInfoUpdateEnabled(enabled);
        this.setHeapSegmentUpdateEnabled(enabled);
    }

    public void setHeapInfoUpdateEnabled(boolean enabled) {
        this.mHeapInfoUpdateEnabled = enabled;
        try {
            HandleHeap.sendHPIF(this, enabled ? 3 : 0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.update(32);
    }

    public void setHeapSegmentUpdateEnabled(boolean enabled) {
        this.mHeapSegmentUpdateEnabled = enabled;
        try {
            HandleHeap.sendHPSG(this, enabled ? 1 : 0, 0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.update(32);
    }

    public void initializeHeapUpdateStatus() {
        this.setHeapInfoUpdateEnabled(this.mHeapInfoUpdateEnabled);
    }

    public void updateHeapInfo() {
        try {
            HandleHeap.sendHPIF(this, 1);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isHeapUpdateEnabled() {
        return this.mHeapInfoUpdateEnabled || this.mHeapSegmentUpdateEnabled;
    }

    public boolean requestNativeHeapInformation() {
        try {
            HandleNativeHeap.sendNHGT(this);
            return true;
        }
        catch (IOException e11) {
            Log.e("ddmlib", e11);
            return false;
        }
    }

    @Override
    public void enableAllocationTracker(boolean enable) {
        try {
            HandleHeap.sendREAE(this, enable);
        }
        catch (IOException e11) {
            Log.e("ddmlib", e11);
        }
    }

    public void requestAllocationStatus() {
        try {
            HandleHeap.sendREAQ(this);
        }
        catch (IOException e11) {
            Log.w("ddmlib", "IO Error while obtaining allocation status");
        }
    }

    @Override
    public void requestAllocationDetails() {
        try {
            HandleHeap.sendREAL(this);
        }
        catch (IOException e11) {
            Log.e("ddmlib", e11);
        }
    }

    @Override
    public void kill() {
        try {
            HandleExit.sendEXIT(this, 1);
        }
        catch (IOException ioe) {
            Log.w("ddms", "Send of EXIT message failed");
        }
    }

    public void register(Selector sel) throws IOException {
        SocketChannel chan = this.mChan;
        if (chan != null) {
            chan.register(sel, 1, this);
        }
    }

    void listenForDebugger() throws IOException {
        this.mDebugger = new Debugger(this);
    }

    boolean sendHandshake() {
        ByteBuffer tempBuffer = ByteBuffer.allocate(JdwpHandshake.HANDSHAKE_LEN);
        try {
            JdwpHandshake.putHandshake(tempBuffer);
            int expectedLen = tempBuffer.position();
            tempBuffer.flip();
            Log.v("ddms-client", ">>> Writing " + tempBuffer.remaining() + " bytes to socket (handshake)");
            Log.hexDump("ddms", Log.LogLevel.VERBOSE, tempBuffer.array(), tempBuffer.arrayOffset() + tempBuffer.position(), tempBuffer.remaining());
            if (this.mChan.write(tempBuffer) != expectedLen) {
                throw new IOException("partial handshake write");
            }
        }
        catch (IOException ioe) {
            Log.e("ddms-client", "IO error during handshake: " + ioe.getMessage());
            this.mConnState = 20;
            this.close(true);
            return false;
        }
        this.mConnState = 10;
        return true;
    }

    @Override
    protected void send(JdwpPacket p11) throws IOException {
        JdwpTrafficResponse resp = this.scache.onUpstreamPacket(ByteBuffer.wrap(p11.getPayload().array(), 0, p11.getLength()));
        for (ByteBuffer b11 : resp.getEdict().getToUpstream()) {
            b11.position(b11.limit());
            this.writeToSocket(JdwpPacket.findPacket(b11.duplicate()));
        }
        for (ByteBuffer b11 : resp.getEdict().getToDownstream()) {
            b11.position(b11.limit());
            this.incoming(JdwpPacket.findPacket(b11.duplicate()), this.getDebugger());
        }
        for (ByteBuffer b11 : resp.getJournal().getToUpstream()) {
            b11.rewind();
            this.jdwpTracer.onUpstreamPacket(b11);
        }
        for (ByteBuffer b11 : resp.getJournal().getToDownstream()) {
            b11.rewind();
            this.jdwpTracer.onDownstreamPacket(b11);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeToSocket(JdwpPacket p11) throws IOException {
        SocketChannel chan = this.mChan;
        if (chan == null) {
            Log.v("ddms", "Not sending packet -- client is closed");
            return;
        }
        SocketChannel socketChannel = chan;
        synchronized (socketChannel) {
            try {
                p11.write(chan);
            }
            catch (IOException ioe) {
                this.removeReplyInterceptor(p11.getId());
                throw ioe;
            }
        }
    }

    public void read() throws IOException, BufferOverflowException {
        int count;
        SocketChannel chan = this.mChan;
        if (chan == null) {
            throw new IOException("Can't read from a closed channel.");
        }
        if (this.mReadBuffer.position() == this.mReadBuffer.capacity()) {
            if (this.mReadBuffer.capacity() * 2 > this.mMaxPacketSize) {
                Log.e("ddms", "Exceeded MAX_BUF_SIZE!");
                throw new BufferOverflowException();
            }
            Log.d("ddms", "Expanding read buffer to " + this.mReadBuffer.capacity() * 2);
            ByteBuffer newBuffer = ByteBuffer.allocate(this.mReadBuffer.capacity() * 2);
            this.mReadBuffer.position(0);
            newBuffer.put(this.mReadBuffer);
            this.mReadBuffer = newBuffer;
        }
        if ((count = chan.read(this.mReadBuffer)) < 0) {
            throw new IOException("read failed");
        }
        Log.v("ddms", "Read " + count + " bytes from " + this);
        Log.hexDump("ddms", Log.LogLevel.VERBOSE, this.mReadBuffer.array(), this.mReadBuffer.arrayOffset(), this.mReadBuffer.position());
    }

    void consumeReadBuffer() throws IOException {
        JdwpPacket packet = this.getJdwpPacket();
        while (packet != null) {
            ByteBuffer buffer = ByteBuffer.wrap(packet.getPayload().array(), 0, packet.getLength());
            JdwpTrafficResponse resp = this.scache.onDownstreamPacket(buffer);
            for (ByteBuffer b11 : resp.getEdict().getToUpstream()) {
                b11.position(b11.limit());
                this.writeToSocket(JdwpPacket.findPacket(b11));
            }
            for (ByteBuffer b11 : resp.getEdict().getToDownstream()) {
                b11.position(b11.limit());
                this.incoming(JdwpPacket.findPacket(b11), this.getDebugger());
            }
            for (ByteBuffer b11 : resp.getJournal().getToUpstream()) {
                b11.rewind();
                this.jdwpTracer.onUpstreamPacket(b11);
            }
            for (ByteBuffer b11 : resp.getJournal().getToDownstream()) {
                b11.rewind();
                this.jdwpTracer.onDownstreamPacket(b11);
            }
            packet.consume();
            packet = this.getJdwpPacket();
        }
    }

    public JdwpPacket getJdwpPacket() throws IOException {
        if (this.mConnState == 10) {
            this.consumeInvalidPackets();
            switch (JdwpHandshake.findHandshake(this.mReadBuffer)) {
                case 1: {
                    Log.d("ddms", "Good handshake from client, sending HELO to " + this.mClientData.getPid());
                    JdwpHandshake.consumeHandshake(this.mReadBuffer);
                    this.mConnState = 11;
                    HandleHello.sendHelloCommands(this, 1);
                    return this.getJdwpPacket();
                }
                case 3: {
                    Log.d("ddms", "Bad handshake from client");
                    if (MonitorThread.getInstance().getRetryOnBadHandshake()) {
                        this.mDevice.getClientTracker().trackClientToDropAndReopen(this);
                        break;
                    }
                    this.mConnState = 2;
                    this.close(true);
                    break;
                }
                case 2: {
                    Log.d("ddms", "No handshake from client yet.");
                    break;
                }
                default: {
                    Log.e("ddms", "Unknown packet while waiting for client handshake");
                }
            }
            return null;
        }
        if (this.mConnState == 11 || this.mConnState == 12 || this.mConnState == 13) {
            if (this.mReadBuffer.position() != 0) {
                Log.v("ddms", "Checking " + this.mReadBuffer.position() + " bytes");
            }
            return JdwpPacket.findPacket(this.mReadBuffer);
        }
        Log.e("ddms", "Receiving data in state = " + this.mConnState);
        return null;
    }

    /*
     * Exception decompiling
     */
    void consumeInvalidPackets() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void packetFailed(JdwpPacket reply) {
        if (this.mConnState == 11) {
            Log.d("ddms", "Marking " + this + " as non-DDM client");
            this.mConnState = 12;
        } else if (this.mConnState != 12) {
            Log.w("ddms", "WEIRD: got JDWP failure packet on DDM req");
        }
    }

    public synchronized boolean ddmSeen() {
        if (this.mConnState == 11) {
            this.mConnState = 13;
            return false;
        }
        if (this.mConnState != 13) {
            Log.w("ddms", "WEIRD: in ddmSeen with state=" + this.mConnState);
        }
        return true;
    }

    public void close(boolean notify) {
        Log.d("ddms", "Closing " + this.toString());
        this.jdwpTracer.close();
        this.clear();
        try {
            SocketChannel chan = this.mChan;
            this.mChan = null;
            if (chan != null) {
                chan.close();
            }
            if (this.mDebugger != null) {
                this.mDebugger.close();
                this.mDebugger = null;
            }
        }
        catch (IOException ioe) {
            Log.w("ddms", "failed to close " + this);
        }
        this.mDevice.removeClient(this, notify);
    }

    @Override
    public boolean isValid() {
        return this.mChan != null;
    }

    public void update(int changeMask) {
        this.mDevice.update(this, changeMask);
    }

    @Override
    public void notifyVmMirrorExited() {
        this.mDevice.getClientTracker().trackClientToDropAndReopen(this);
    }

    @Override
    public void listViewRoots(DebugViewDumpHandler replyHandler) throws IOException {
        HandleViewDebug.listViewRoots(this, replyHandler);
    }

    @Override
    public void captureView(String viewRoot, String view, DebugViewDumpHandler handler) throws IOException {
        HandleViewDebug.captureView(this, viewRoot, view, handler);
    }

    @Override
    public void dumpViewHierarchy(String viewRoot, boolean skipChildren, boolean includeProperties, boolean useV2, DebugViewDumpHandler handler) throws IOException {
        HandleViewDebug.dumpViewHierarchy(this, viewRoot, skipChildren, includeProperties, useV2, handler);
    }

    @Override
    public void dumpDisplayList(String viewRoot, String view) throws IOException {
        HandleViewDebug.dumpDisplayList(this, viewRoot, view);
    }
}

