/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.ddmlib.logcat;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class LogCatTimestamp {
    private static final Pattern sTimePattern = Pattern.compile("^(\\d\\d)-(\\d\\d)\\s(\\d\\d):(\\d\\d):(\\d\\d)\\.(\\d+)$");

    private LogCatTimestamp() {
    }

    public static Instant parse(String timeString) {
        return LogCatTimestamp.parse(timeString, ZonedDateTime.now().getYear(), ZoneId.systemDefault());
    }

    static Instant parse(String timeString, int year, ZoneId zoneId) {
        int millisecond;
        Matcher matcher = sTimePattern.matcher(timeString);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid timestamp. Expected MM-DD HH:MM:SS:mmm");
        }
        int month = Integer.parseInt(matcher.group(1));
        int day = Integer.parseInt(matcher.group(2));
        int hour = Integer.parseInt(matcher.group(3));
        int minute = Integer.parseInt(matcher.group(4));
        int second = Integer.parseInt(matcher.group(5));
        for (millisecond = Integer.parseInt(matcher.group(6)); millisecond >= 1000; millisecond /= 10) {
        }
        return Instant.from(ZonedDateTime.of(year, month, day, hour, minute, second, (int)TimeUnit.MILLISECONDS.toNanos(millisecond), zoneId));
    }
}

