/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.apksig.util;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Phaser;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import shadow.bundletool.com.android.apksig.util.RunnablesProvider;

public interface RunnablesExecutor {
    public static final RunnablesExecutor SINGLE_THREADED = p4 -> p4.createRunnable().run();
    public static final RunnablesExecutor MULTI_THREADED = new RunnablesExecutor(){
        private final int PARALLELISM = Math.min(32, Runtime.getRuntime().availableProcessors());
        private final int QUEUE_SIZE = 4;

        @Override
        public void execute(RunnablesProvider provider) {
            ThreadPoolExecutor mExecutor = new ThreadPoolExecutor(this.PARALLELISM, this.PARALLELISM, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(4), new ThreadPoolExecutor.CallerRunsPolicy());
            Phaser tasks = new Phaser(1);
            for (int i4 = 0; i4 < this.PARALLELISM; ++i4) {
                Runnable task = () -> {
                    Runnable r4 = provider.createRunnable();
                    r4.run();
                    tasks.arriveAndDeregister();
                };
                tasks.register();
                mExecutor.execute(task);
            }
            tasks.arriveAndAwaitAdvance();
            mExecutor.shutdownNow();
        }
    };

    public void execute(RunnablesProvider var1);
}

