/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.internal.ExtraModelInfo;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.dependency.JarInfo;
import com.android.build.gradle.internal.dependency.LibInfo;
import com.android.build.gradle.internal.dependency.LibraryDependencyImpl;
import com.android.build.gradle.internal.dependency.ManifestDependencyImpl;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.model.MavenCoordinatesImpl;
import com.android.build.gradle.internal.tasks.PrepareDependenciesTask;
import com.android.build.gradle.internal.tasks.PrepareLibraryTask;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.builder.core.ErrorReporter;
import com.android.builder.dependency.DependencyContainer;
import com.android.builder.dependency.JarDependency;
import com.android.builder.dependency.LibraryDependency;
import com.android.builder.model.MavenCoordinates;
import com.android.utils.ILogger;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.gradle.api.CircularReferenceException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UnknownProjectException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.SelfResolvingDependency;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.artifacts.result.UnresolvedDependencyResult;
import org.gradle.api.logging.Logging;
import org.gradle.api.specs.Specs;
import org.gradle.util.GUtil;

public class DependencyManager {
    protected static final boolean DEBUG_DEPENDENCY = false;
    private Project project;
    private ExtraModelInfo extraModelInfo;
    private ILogger logger;
    final Map<LibraryDependencyImpl, PrepareLibraryTask> prepareTaskMap = Maps.newHashMap();

    public DependencyManager(Project project, ExtraModelInfo extraModelInfo) {
        this.project = project;
        this.extraModelInfo = extraModelInfo;
        this.logger = new LoggerWrapper(Logging.getLogger(DependencyManager.class));
    }

    public static List<File> getPackagedLocalJarFileList(DependencyContainer dependencyContainer) {
        List jarDependencyList = dependencyContainer.getLocalDependencies();
        HashSet files = Sets.newHashSetWithExpectedSize((int)jarDependencyList.size());
        for (JarDependency jarDependency : jarDependencyList) {
            if (!jarDependency.isPackaged()) continue;
            files.add(jarDependency.getJarFile());
        }
        return Lists.newArrayList((Iterable)files);
    }

    public void addDependencyToPrepareTask(BaseVariantData<? extends BaseVariantOutputData> variantData, PrepareDependenciesTask prepareDependenciesTask, LibraryDependencyImpl lib) {
        PrepareLibraryTask prepareLibTask = this.prepareTaskMap.get((Object)lib.getNonTransitiveRepresentation());
        if (prepareLibTask != null) {
            prepareDependenciesTask.dependsOn(new Object[]{prepareLibTask});
            prepareLibTask.dependsOn(new Object[]{variantData.preBuildTask});
        }
        for (LibraryDependency childLib : lib.getDependencies()) {
            this.addDependencyToPrepareTask(variantData, prepareDependenciesTask, (LibraryDependencyImpl)childLib);
        }
    }

    public void resolveDependencies(VariantDependencies variantDeps, VariantDependencies testedVariantDeps, String testedProjectPath) {
        ArrayListMultimap reverseMap = ArrayListMultimap.create();
        this.resolveDependencyForConfig(variantDeps, testedVariantDeps, testedProjectPath, (Multimap<LibraryDependency, VariantDependencies>)reverseMap);
        this.processLibraries(variantDeps.getLibraries(), (Multimap<LibraryDependency, VariantDependencies>)reverseMap);
    }

    private void processLibraries(Collection<LibraryDependencyImpl> libraries, Multimap<LibraryDependency, VariantDependencies> reverseMap) {
        for (LibraryDependencyImpl lib : libraries) {
            this.setupPrepareLibraryTask(lib, reverseMap);
            this.processLibraries(lib.getDependencies(), reverseMap);
        }
    }

    private void setupPrepareLibraryTask(LibraryDependencyImpl libDependency, Multimap<LibraryDependency, VariantDependencies> reverseMap) {
        PrepareLibraryTask task = this.maybeCreatePrepareLibraryTask(libDependency, this.project);
        Collection configDepList = reverseMap.get((Object)libDependency);
        if (configDepList != null && !configDepList.isEmpty()) {
            for (VariantDependencies configDependencies : configDepList) {
                task.dependsOn(new Object[]{configDependencies.getCompileConfiguration().getBuildDependencies()});
            }
        }
    }

    private PrepareLibraryTask maybeCreatePrepareLibraryTask(LibraryDependencyImpl library, Project project) {
        LibraryDependencyImpl key = library.getNonTransitiveRepresentation();
        PrepareLibraryTask prepareLibraryTask = this.prepareTaskMap.get((Object)key);
        if (prepareLibraryTask == null) {
            String bundleName = GUtil.toCamelCase((CharSequence)library.getName().replaceAll("\\:", " "));
            prepareLibraryTask = (PrepareLibraryTask)project.getTasks().create("prepare" + bundleName + "Library", PrepareLibraryTask.class);
            prepareLibraryTask.setDescription("Prepare " + library.getName());
            prepareLibraryTask.setBundle(library.getBundle());
            prepareLibraryTask.setExplodedDir(library.getBundleFolder());
            prepareLibraryTask.setVariantName("");
            this.prepareTaskMap.put(key, prepareLibraryTask);
        }
        return prepareLibraryTask;
    }

    private void resolveDependencyForConfig(VariantDependencies variantDeps, VariantDependencies testedVariantDeps, String testedProjectPath, Multimap<LibraryDependency, VariantDependencies> reverseMap) {
        Configuration compileClasspath = variantDeps.getCompileConfiguration();
        Configuration packageClasspath = variantDeps.getPackageConfiguration();
        this.ensureConfigured(compileClasspath);
        this.ensureConfigured(packageClasspath);
        HashSet currentUnresolvedDependencies = Sets.newHashSet();
        HashMap artifacts = Maps.newHashMap();
        this.collectArtifacts(compileClasspath, artifacts);
        this.collectArtifacts(packageClasspath, artifacts);
        HashMap foundLibraries = Maps.newHashMap();
        HashMap foundJars = Maps.newHashMap();
        ArrayList compiledAndroidLibraries = Lists.newArrayList();
        ArrayList compiledJars = Lists.newArrayList();
        Set dependencyResultSet = compileClasspath.getIncoming().getResolutionResult().getRoot().getDependencies();
        for (DependencyResult dependencyResult : dependencyResultSet) {
            ComponentSelector attempted;
            if (dependencyResult instanceof ResolvedDependencyResult) {
                this.addDependency(((ResolvedDependencyResult)dependencyResult).getSelected(), variantDeps, compiledAndroidLibraries, compiledJars, foundLibraries, foundJars, artifacts, reverseMap, currentUnresolvedDependencies, testedProjectPath, Collections.<String>emptyList(), 0);
                continue;
            }
            if (!(dependencyResult instanceof UnresolvedDependencyResult) || (attempted = ((UnresolvedDependencyResult)dependencyResult).getAttempted()) == null) continue;
            currentUnresolvedDependencies.add(attempted.toString());
        }
        ArrayList packagedAndroidLibraries = Lists.newArrayList();
        ArrayList packagedJars = Lists.newArrayList();
        dependencyResultSet = packageClasspath.getIncoming().getResolutionResult().getRoot().getDependencies();
        for (DependencyResult dependencyResult : dependencyResultSet) {
            ComponentSelector attempted;
            if (dependencyResult instanceof ResolvedDependencyResult) {
                this.addDependency(((ResolvedDependencyResult)dependencyResult).getSelected(), variantDeps, packagedAndroidLibraries, packagedJars, foundLibraries, foundJars, artifacts, reverseMap, currentUnresolvedDependencies, testedProjectPath, Collections.<String>emptyList(), 0);
                continue;
            }
            if (!(dependencyResult instanceof UnresolvedDependencyResult) || (attempted = ((UnresolvedDependencyResult)dependencyResult).getAttempted()) == null) continue;
            currentUnresolvedDependencies.add(attempted.toString());
        }
        ArrayList copyOfPackagedLibs = Lists.newArrayList((Iterable)packagedAndroidLibraries);
        boolean isLibrary = this.extraModelInfo.isLibrary();
        for (LibInfo lib : compiledAndroidLibraries) {
            if (!copyOfPackagedLibs.contains((Object)lib)) {
                if (isLibrary || lib.isOptional()) {
                    lib.setIsOptional(true);
                    continue;
                }
                variantDeps.getChecker().addSyncIssue(this.extraModelInfo.handleSyncError(lib.getResolvedCoordinates().toString(), 7, String.format("Project %s: provided dependencies can only be jars. %s is an Android Library.", this.project.getName(), lib.getResolvedCoordinates())));
                continue;
            }
            copyOfPackagedLibs.remove((Object)lib);
        }
        for (LibInfo lib : copyOfPackagedLibs) {
            variantDeps.getChecker().addSyncIssue(this.extraModelInfo.handleSyncError(lib.getResolvedCoordinates().toString(), 6, String.format("Project %s: apk dependencies can only be jars. %s is an Android Library.", this.project.getName(), lib.getResolvedCoordinates())));
        }
        Set jarInfoSet = Sets.newIdentityHashSet();
        Set libInfoSet = Sets.newIdentityHashSet();
        DependencyManager.gatherJarDependencies(jarInfoSet, compiledJars, true, false);
        DependencyManager.gatherJarDependencies(jarInfoSet, packagedJars, false, true);
        DependencyManager.gatherJarDependenciesFromLibraries(jarInfoSet, compiledAndroidLibraries);
        DependencyManager.gatherAndroidDependencies(libInfoSet, compiledAndroidLibraries);
        ArrayList jars = Lists.newArrayListWithCapacity((int)jarInfoSet.size());
        HashSet librariesToKeep = Sets.newHashSetWithExpectedSize((int)compiledAndroidLibraries.size());
        if (testedVariantDeps != null) {
            MavenCoordinates coordinates;
            List<JarDependency> jarDependencies = testedVariantDeps.getJarDependencies();
            HashMap testedJarDeps = Maps.newHashMapWithExpectedSize((int)jarDependencies.size());
            for (JarDependency jarDependency : jarDependencies) {
                if (!jarDependency.isPackaged()) continue;
                MavenCoordinates coordinates2 = jarDependency.getResolvedCoordinates();
                Preconditions.checkState((coordinates2 != null ? 1 : 0) != 0);
                testedJarDeps.put(DependencyManager.computeVersionLessCoordinateKey(coordinates2), coordinates2.getVersion());
            }
            for (JarInfo jarInfo : jarInfoSet) {
                if (!jarInfo.isPackaged()) continue;
                MavenCoordinates coordinates2 = jarInfo.getResolvedCoordinates();
                String string = (String)testedJarDeps.get(DependencyManager.computeVersionLessCoordinateKey(coordinates2));
                if (string != null) {
                    this.skipTestDependency(variantDeps, coordinates2, string);
                    continue;
                }
                jars.add(jarInfo.createJarDependency());
            }
            List<? extends LibraryDependency> androidDependencies = testedVariantDeps.getAndroidDependencies();
            HashMap hashMap = Maps.newHashMapWithExpectedSize((int)jarDependencies.size());
            for (LibraryDependency libraryDependency : androidDependencies) {
                coordinates = libraryDependency.getResolvedCoordinates();
                Preconditions.checkState((coordinates != null ? 1 : 0) != 0);
                hashMap.put(DependencyManager.computeVersionLessCoordinateKey(coordinates), coordinates.getVersion());
            }
            for (LibInfo libInfo : libInfoSet) {
                coordinates = libInfo.getResolvedCoordinates();
                Preconditions.checkState((coordinates != null ? 1 : 0) != 0);
                String testedVersion = (String)hashMap.get(DependencyManager.computeVersionLessCoordinateKey(coordinates));
                if (testedVersion != null) {
                    this.skipTestDependency(variantDeps, coordinates, testedVersion);
                    continue;
                }
                librariesToKeep.add(libInfo);
            }
        } else {
            for (JarInfo jarInfo : jarInfoSet) {
                jars.add(jarInfo.createJarDependency());
            }
            librariesToKeep.addAll(libInfoSet);
        }
        HashSet localCompiledJars = Sets.newHashSet();
        for (Dependency dependency : compileClasspath.getAllDependencies()) {
            if (!(dependency instanceof SelfResolvingDependency) || dependency instanceof ProjectDependency) continue;
            Set set = ((SelfResolvingDependency)dependency).resolve();
            for (File file : set) {
                if (!file.getName().toLowerCase(Locale.getDefault()).endsWith(".jar")) {
                    variantDeps.getChecker().addSyncIssue(this.extraModelInfo.handleSyncError(file.getAbsolutePath(), 5, String.format("Project %s: Only Jar-type local dependencies are supported. Cannot handle: %s", this.project.getName(), file.getAbsolutePath())));
                    continue;
                }
                localCompiledJars.add(file);
            }
        }
        HashSet localPackagedJars = Sets.newHashSet();
        for (Dependency dependency : packageClasspath.getAllDependencies()) {
            if (!(dependency instanceof SelfResolvingDependency) || dependency instanceof ProjectDependency) continue;
            Set files = ((SelfResolvingDependency)dependency).resolve();
            for (File f : files) {
                if (!f.getName().toLowerCase(Locale.getDefault()).endsWith(".jar")) {
                    variantDeps.getChecker().addSyncIssue(this.extraModelInfo.handleSyncError(f.getAbsolutePath(), 5, String.format("Project %s: Only Jar-type local dependencies are supported. Cannot handle: %s", this.project.getName(), f.getAbsolutePath())));
                    continue;
                }
                localPackagedJars.add(f);
            }
        }
        HashMap localJars = Maps.newHashMap();
        for (File file : localCompiledJars) {
            localJars.put(file, new JarDependency(file, true, localPackagedJars.contains(file), null, null));
        }
        for (File file : localPackagedJars) {
            if (localCompiledJars.contains(file)) continue;
            localJars.put(file, new JarDependency(file, false, true, null, null));
        }
        if (this.extraModelInfo.getMode() != ErrorReporter.EvaluationMode.STANDARD && compileClasspath.getResolvedConfiguration().hasError()) {
            for (String dependency : currentUnresolvedDependencies) {
                this.extraModelInfo.handleSyncError(dependency, 2, String.format("Unable to resolve dependency '%s'", dependency));
            }
        }
        List<LibraryDependencyImpl> list = DependencyManager.convertLibraryInfoIntoDependency(compiledAndroidLibraries, librariesToKeep, reverseMap);
        variantDeps.addLibraries(list);
        variantDeps.addJars(jars);
        variantDeps.addLocalJars(localJars.values());
        this.configureBuild(variantDeps);
    }

    private void skipTestDependency(VariantDependencies variantDeps, MavenCoordinates coordinates, String testedVersion) {
        if (!testedVersion.equals(coordinates.getVersion())) {
            String artifactInfo = coordinates.getGroupId() + ":" + coordinates.getArtifactId();
            variantDeps.getChecker().addSyncIssue(this.extraModelInfo.handleSyncError(artifactInfo, 9, String.format("Conflict with dependency '%s'. Resolved versions for app (%s) and test app (%s) differ. See http://g.co/androidstudio/app-test-app-conflict for details.", artifactInfo, testedVersion, coordinates.getVersion())));
        } else {
            this.logger.info(String.format("Removed '%s' from packaging of %s: Already in tested package.", coordinates, variantDeps.getName()), new Object[0]);
        }
    }

    private static List<LibraryDependencyImpl> convertLibraryInfoIntoDependency(List<LibInfo> libInfos, Set<LibInfo> librariesToKeep, Multimap<LibraryDependency, VariantDependencies> reverseMap) {
        ArrayList list = Lists.newArrayListWithCapacity((int)libInfos.size());
        IdentityHashMap convertedMap = Maps.newIdentityHashMap();
        for (LibInfo libInfo : libInfos) {
            if (!librariesToKeep.contains((Object)libInfo)) continue;
            list.add(DependencyManager.convertLibInfo(libInfo, librariesToKeep, reverseMap, convertedMap));
        }
        return list;
    }

    private static LibraryDependencyImpl convertLibInfo(LibInfo libInfo, Set<LibInfo> librariesToKeep, Multimap<LibraryDependency, VariantDependencies> reverseMap, Map<LibInfo, LibraryDependencyImpl> convertedMap) {
        LibraryDependencyImpl convertedLib = convertedMap.get((Object)libInfo);
        if (convertedLib == null) {
            List<LibraryDependency> children = libInfo.getDependencies();
            ArrayList convertedChildren = Lists.newArrayListWithCapacity((int)children.size());
            for (LibInfo libInfo2 : children) {
                if (!librariesToKeep.contains((Object)libInfo2)) continue;
                convertedChildren.add(DependencyManager.convertLibInfo(libInfo2, librariesToKeep, reverseMap, convertedMap));
            }
            convertedLib = new LibraryDependencyImpl(libInfo.getBundle(), libInfo.getFolder(), convertedChildren, libInfo.getName(), libInfo.getProjectVariant(), libInfo.getProject(), libInfo.getRequestedCoordinates(), libInfo.getResolvedCoordinates(), libInfo.isOptional());
            convertedMap.put(libInfo, convertedLib);
            ArrayList values = Lists.newArrayList((Iterable)reverseMap.get((Object)libInfo));
            reverseMap.removeAll((Object)libInfo);
            reverseMap.putAll((Object)convertedLib, (Iterable)values);
        }
        return convertedLib;
    }

    private static void gatherJarDependencies(Set<JarInfo> outJarInfos, Collection<JarInfo> inJarInfos, boolean compiled, boolean packaged) {
        for (JarInfo jarInfo : inJarInfos) {
            outJarInfos.add(jarInfo);
            if (compiled) {
                jarInfo.setCompiled(true);
            }
            if (packaged) {
                jarInfo.setPackaged(true);
            }
            DependencyManager.gatherJarDependencies(outJarInfos, jarInfo.getDependencies(), compiled, packaged);
        }
    }

    private static void gatherAndroidDependencies(Set<LibInfo> outLibInfos, Collection<LibInfo> inLibInfos) {
        for (LibInfo libInfo : inLibInfos) {
            outLibInfos.add(libInfo);
            DependencyManager.gatherAndroidDependencies(outLibInfos, libInfo.getLibInfoDependencies());
        }
    }

    private static void gatherJarDependenciesFromLibraries(Set<JarInfo> outJarInfos, Collection<LibInfo> inLibraryDependencies) {
        for (LibInfo libInfo : inLibraryDependencies) {
            DependencyManager.gatherJarDependencies(outJarInfos, libInfo.getJarDependencies(), true, !libInfo.isOptional());
            DependencyManager.gatherJarDependenciesFromLibraries(outJarInfos, libInfo.getLibInfoDependencies());
        }
    }

    private void ensureConfigured(Configuration config) {
        for (Dependency dependency : config.getAllDependencies()) {
            if (!(dependency instanceof ProjectDependency)) continue;
            ProjectDependency projectDependency = (ProjectDependency)dependency;
            this.project.evaluationDependsOn(projectDependency.getDependencyProject().getPath());
            try {
                this.ensureConfigured(projectDependency.getProjectConfiguration());
            }
            catch (Throwable e) {
                throw new UnknownProjectException(String.format("Cannot evaluate module %s : %s", projectDependency.getName(), e.getMessage()), e);
            }
        }
    }

    private void collectArtifacts(Configuration configuration, Map<ModuleVersionIdentifier, List<ResolvedArtifact>> artifacts) {
        Set allArtifacts = this.extraModelInfo.getMode() != ErrorReporter.EvaluationMode.STANDARD ? configuration.getResolvedConfiguration().getLenientConfiguration().getArtifacts(Specs.satisfyAll()) : configuration.getResolvedConfiguration().getResolvedArtifacts();
        for (ResolvedArtifact artifact : allArtifacts) {
            ModuleVersionIdentifier id = artifact.getModuleVersion().getId();
            ArrayList moduleArtifacts = artifacts.get(id);
            if (moduleArtifacts == null) {
                moduleArtifacts = Lists.newArrayList();
                artifacts.put(id, moduleArtifacts);
            }
            if (moduleArtifacts.contains(artifact)) continue;
            moduleArtifacts.add(artifact);
        }
    }

    private static void printIndent(int indent, String message) {
        for (int i = 0; i < indent; ++i) {
            System.out.print("\t");
        }
        System.out.println(message);
    }

    private void addDependency(ResolvedComponentResult resolvedComponentResult, VariantDependencies configDependencies, Collection<LibInfo> outLibraries, List<JarInfo> outJars, Map<ModuleVersionIdentifier, List<LibInfo>> alreadyFoundLibraries, Map<ModuleVersionIdentifier, List<JarInfo>> alreadyFoundJars, Map<ModuleVersionIdentifier, List<ResolvedArtifact>> artifacts, Multimap<LibraryDependency, VariantDependencies> reverseMap, Set<String> currentUnresolvedDependencies, String testedProjectPath, List<String> projectChain, int indent) {
        block19: {
            String gradlePath;
            ArrayList jarsForThisModule;
            ArrayList libsForThisModule;
            ModuleVersionIdentifier moduleVersion;
            block20: {
                block18: {
                    moduleVersion = resolvedComponentResult.getModuleVersion();
                    if (configDependencies.getChecker().excluded(moduleVersion)) {
                        return;
                    }
                    if (moduleVersion.getName().equals("support-annotations") && moduleVersion.getGroup().equals("com.android.support")) {
                        configDependencies.setAnnotationsPresent(true);
                    }
                    libsForThisModule = alreadyFoundLibraries.get(moduleVersion);
                    jarsForThisModule = alreadyFoundJars.get(moduleVersion);
                    if (libsForThisModule == null) break block18;
                    outLibraries.addAll(libsForThisModule);
                    for (LibInfo lib : libsForThisModule) {
                        reverseMap.put((Object)lib, (Object)configDependencies);
                    }
                    break block19;
                }
                if (jarsForThisModule == null) break block20;
                outJars.addAll(jarsForThisModule);
                break block19;
            }
            ArrayList nestedLibraries = Lists.newArrayList();
            ArrayList nestedJars = Lists.newArrayList();
            Set dependencies = resolvedComponentResult.getDependencies();
            for (DependencyResult dependencyResult : dependencies) {
                ComponentSelector attempted;
                if (dependencyResult instanceof ResolvedDependencyResult) {
                    ResolvedComponentResult selected = ((ResolvedDependencyResult)dependencyResult).getSelected();
                    ArrayList newProjectChain = projectChain;
                    ComponentIdentifier identifier = selected.getId();
                    if (identifier instanceof ProjectComponentIdentifier) {
                        String projectPath = ((ProjectComponentIdentifier)identifier).getProjectPath();
                        int index = projectChain.indexOf(projectPath);
                        if (index != -1) {
                            projectChain.add(projectPath);
                            String path = Joiner.on((String)" -> ").join(projectChain.subList(index, projectChain.size()));
                            throw new CircularReferenceException("Circular reference between projects: " + path);
                        }
                        newProjectChain = Lists.newArrayList();
                        newProjectChain.addAll(projectChain);
                        newProjectChain.add(projectPath);
                    }
                    this.addDependency(selected, configDependencies, nestedLibraries, nestedJars, alreadyFoundLibraries, alreadyFoundJars, artifacts, reverseMap, currentUnresolvedDependencies, testedProjectPath, newProjectChain, indent + 1);
                    continue;
                }
                if (!(dependencyResult instanceof UnresolvedDependencyResult) || (attempted = ((UnresolvedDependencyResult)dependencyResult).getAttempted()) == null) continue;
                currentUnresolvedDependencies.add(attempted.toString());
            }
            List<ResolvedArtifact> moduleArtifacts = artifacts.get(moduleVersion);
            ComponentIdentifier id = resolvedComponentResult.getId();
            String string = gradlePath = id instanceof ProjectComponentIdentifier ? ((ProjectComponentIdentifier)id).getProjectPath() : null;
            if (moduleArtifacts == null) break block19;
            for (ResolvedArtifact artifact : moduleArtifacts) {
                String name;
                if ("aar".equals(artifact.getExtension())) {
                    if (libsForThisModule == null) {
                        libsForThisModule = Lists.newArrayList();
                        alreadyFoundLibraries.put(moduleVersion, libsForThisModule);
                    }
                    String path = this.computeArtifactPath(moduleVersion, artifact);
                    String name2 = DependencyManager.computeArtifactName(moduleVersion, artifact);
                    File explodedDir = this.project.file((Object)(this.project.getBuildDir() + "/" + "intermediates" + "/exploded-aar/" + path));
                    LibInfo libInfo = new LibInfo(artifact.getFile(), explodedDir, (List<LibraryDependency>)nestedLibraries, nestedJars, name2, artifact.getClassifier(), gradlePath, null, new MavenCoordinatesImpl(artifact));
                    libsForThisModule.add(libInfo);
                    outLibraries.add(libInfo);
                    reverseMap.put((Object)libInfo, (Object)configDependencies);
                    continue;
                }
                if ("jar".equals(artifact.getExtension())) {
                    if (!nestedLibraries.isEmpty()) {
                        if (testedProjectPath != null && testedProjectPath.equals(gradlePath)) {
                            for (LibInfo lib : nestedLibraries) {
                                lib.setIsOptional(true);
                            }
                            outLibraries.addAll(nestedLibraries);
                        } else {
                            configDependencies.getChecker().addSyncIssue(this.extraModelInfo.handleSyncError(new MavenCoordinatesImpl(artifact).toString(), 8, String.format("Module '%s' depends on one or more Android Libraries but is a jar", moduleVersion)));
                        }
                    }
                    if (jarsForThisModule == null) {
                        jarsForThisModule = Lists.newArrayList();
                        alreadyFoundJars.put(moduleVersion, jarsForThisModule);
                    }
                    JarInfo jarInfo = new JarInfo(artifact.getFile(), new MavenCoordinatesImpl(artifact), gradlePath, nestedJars);
                    jarsForThisModule.add(jarInfo);
                    outJars.add(jarInfo);
                    continue;
                }
                if ("apk".equals(artifact.getExtension())) {
                    name = DependencyManager.computeArtifactName(moduleVersion, artifact);
                    configDependencies.getChecker().addSyncIssue(this.extraModelInfo.handleSyncError(name, 3, String.format("Dependency %s on project %s resolves to an APK archive which is not supported as a compilation dependency. File: %s", name, this.project.getName(), artifact.getFile())));
                    continue;
                }
                if ("apklib".equals(artifact.getExtension())) {
                    name = DependencyManager.computeArtifactName(moduleVersion, artifact);
                    configDependencies.getChecker().addSyncIssue(this.extraModelInfo.handleSyncError(name, 4, String.format("Packaging for dependency %s is 'apklib' and is not supported. Only 'aar' libraries are supported.", name)));
                    continue;
                }
                name = DependencyManager.computeArtifactName(moduleVersion, artifact);
                this.logger.warning(String.format("Unrecognized dependency: '%s' (type: '%s', extension: '%s')", name, artifact.getType(), artifact.getExtension()), new Object[0]);
            }
        }
    }

    private String computeArtifactPath(ModuleVersionIdentifier moduleVersion, ResolvedArtifact artifact) {
        StringBuilder pathBuilder = new StringBuilder();
        pathBuilder.append(DependencyManager.normalize(this.logger, moduleVersion, moduleVersion.getGroup())).append('/').append(DependencyManager.normalize(this.logger, moduleVersion, moduleVersion.getName())).append('/').append(DependencyManager.normalize(this.logger, moduleVersion, moduleVersion.getVersion()));
        if (artifact.getClassifier() != null && !artifact.getClassifier().isEmpty()) {
            pathBuilder.append('/').append(DependencyManager.normalize(this.logger, moduleVersion, artifact.getClassifier()));
        }
        return pathBuilder.toString();
    }

    private static String computeArtifactName(ModuleVersionIdentifier moduleVersion, ResolvedArtifact artifact) {
        StringBuilder nameBuilder = new StringBuilder();
        nameBuilder.append(moduleVersion.getGroup()).append(':').append(moduleVersion.getName()).append(':').append(moduleVersion.getVersion());
        if (artifact.getClassifier() != null && !artifact.getClassifier().isEmpty()) {
            nameBuilder.append(':').append(artifact.getClassifier());
        }
        return nameBuilder.toString();
    }

    static String normalize(ILogger logger, ModuleVersionIdentifier id, String path) {
        if (path == null || path.isEmpty()) {
            logger.info(String.format("When unzipping library '%s:%s:%s, either group, name or version is empty", id.getGroup(), id.getName(), id.getVersion()), new Object[0]);
            return path;
        }
        String normalizedPath = path.replaceAll("[%<>:\"/?*\\\\]", "@");
        if (normalizedPath == null || normalizedPath.isEmpty()) {
            logger.info(String.format("When unzipping library '%s:%s:%s, the normalized '%s' is empty", id.getGroup(), id.getName(), id.getVersion(), path), new Object[0]);
            return path;
        }
        try {
            int pathPointer;
            String suffix = "";
            for (pathPointer = normalizedPath.length() - 1; pathPointer >= 0 && (normalizedPath.charAt(pathPointer) == '.' || normalizedPath.charAt(pathPointer) == ' '); --pathPointer) {
                suffix = suffix + "@";
            }
            if (pathPointer < 0) {
                throw new RuntimeException(String.format("When unzipping library '%s:%s:%s, the path '%s' cannot be transformed into a valid directory name", id.getGroup(), id.getName(), id.getVersion(), path));
            }
            return normalizedPath.substring(0, pathPointer + 1) + suffix;
        }
        catch (Exception e) {
            logger.error((Throwable)e, String.format("When unzipping library '%s:%s:%s', Path normalization failed for input %s", id.getGroup(), id.getName(), id.getVersion(), path), new Object[0]);
            return path;
        }
    }

    private void configureBuild(VariantDependencies configurationDependencies) {
        DependencyManager.addDependsOnTaskInOtherProjects(this.project.getTasks().getByName("buildNeeded"), true, "buildNeeded", "compile");
        DependencyManager.addDependsOnTaskInOtherProjects(this.project.getTasks().getByName("buildDependents"), false, "buildDependents", "compile");
    }

    public static List<ManifestDependencyImpl> getManifestDependencies(List<LibraryDependency> libraries) {
        ArrayList list = Lists.newArrayListWithCapacity((int)libraries.size());
        for (LibraryDependency lib : libraries) {
            List<ManifestDependencyImpl> children = DependencyManager.getManifestDependencies(lib.getDependencies());
            list.add(new ManifestDependencyImpl(lib.getName(), lib.getManifest(), children));
        }
        return list;
    }

    private static void addDependsOnTaskInOtherProjects(Task task, boolean useDependedOn, String otherProjectTaskName, String configurationName) {
        Project project = task.getProject();
        Configuration configuration = project.getConfigurations().getByName(configurationName);
        task.dependsOn(new Object[]{configuration.getTaskDependencyFromProjectDependency(useDependedOn, otherProjectTaskName)});
    }

    private static String computeVersionLessCoordinateKey(MavenCoordinates coordinates) {
        StringBuilder sb = new StringBuilder(coordinates.getGroupId());
        sb.append(':').append(coordinates.getArtifactId());
        if (coordinates.getClassifier() != null) {
            sb.append(':').append(coordinates.getClassifier());
        }
        return sb.toString();
    }
}

