/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.api;

import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.api.BaseVariantOutput;
import com.android.build.gradle.internal.api.ImmutableFlavorList;
import com.android.build.gradle.internal.api.ReadOnlyObjectProvider;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.tasks.AidlCompile;
import com.android.build.gradle.tasks.GenerateBuildConfig;
import com.android.build.gradle.tasks.MergeResources;
import com.android.build.gradle.tasks.MergeSourceSetFolders;
import com.android.build.gradle.tasks.NdkCompile;
import com.android.build.gradle.tasks.RenderscriptCompile;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.model.BuildType;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.SourceProvider;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.gradle.api.Task;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.JavaCompile;

abstract class BaseVariantImpl
implements BaseVariant {
    protected AndroidBuilder androidBuilder;
    protected ReadOnlyObjectProvider readOnlyObjectProvider;
    protected List<BaseVariantOutput> outputs = Lists.newArrayListWithExpectedSize((int)1);

    BaseVariantImpl(AndroidBuilder androidBuilder, ReadOnlyObjectProvider readOnlyObjectProvider) {
        this.androidBuilder = androidBuilder;
        this.readOnlyObjectProvider = readOnlyObjectProvider;
    }

    protected abstract BaseVariantData<?> getVariantData();

    public void addOutputs(List<BaseVariantOutput> outputs) {
        this.outputs.addAll(outputs);
    }

    @Override
    public String getName() {
        return this.getVariantData().getVariantConfiguration().getFullName();
    }

    @Override
    public String getDescription() {
        return this.getVariantData().getDescription();
    }

    @Override
    public String getDirName() {
        return this.getVariantData().getVariantConfiguration().getDirName();
    }

    @Override
    public String getBaseName() {
        return this.getVariantData().getVariantConfiguration().getBaseName();
    }

    @Override
    public String getFlavorName() {
        return this.getVariantData().getVariantConfiguration().getFlavorName();
    }

    @Override
    public List<BaseVariantOutput> getOutputs() {
        return this.outputs;
    }

    @Override
    public BuildType getBuildType() {
        return this.readOnlyObjectProvider.getBuildType(this.getVariantData().getVariantConfiguration().getBuildType());
    }

    @Override
    public List<ProductFlavor> getProductFlavors() {
        return new ImmutableFlavorList(this.getVariantData().getVariantConfiguration().getProductFlavors(), this.readOnlyObjectProvider);
    }

    @Override
    public ProductFlavor getMergedFlavor() {
        return this.getVariantData().getVariantConfiguration().getMergedFlavor();
    }

    @Override
    public List<SourceProvider> getSourceSets() {
        return this.getVariantData().getVariantConfiguration().getSortedSourceProviders();
    }

    @Override
    public String getApplicationId() {
        return this.getVariantData().getApplicationId();
    }

    @Override
    public Task getPreBuild() {
        return this.getVariantData().preBuildTask;
    }

    @Override
    public Task getCheckManifest() {
        return this.getVariantData().checkManifestTask;
    }

    @Override
    public AidlCompile getAidlCompile() {
        return this.getVariantData().aidlCompileTask;
    }

    @Override
    public RenderscriptCompile getRenderscriptCompile() {
        return this.getVariantData().renderscriptCompileTask;
    }

    @Override
    public MergeResources getMergeResources() {
        return this.getVariantData().mergeResourcesTask;
    }

    @Override
    public MergeSourceSetFolders getMergeAssets() {
        return this.getVariantData().mergeAssetsTask;
    }

    @Override
    public GenerateBuildConfig getGenerateBuildConfig() {
        return this.getVariantData().generateBuildConfigTask;
    }

    @Override
    public JavaCompile getJavaCompile() {
        return this.getVariantData().javacTask;
    }

    @Override
    public AbstractCompile getJavaCompiler() {
        return this.getVariantData().javaCompilerTask;
    }

    @Override
    public NdkCompile getNdkCompile() {
        return this.getVariantData().ndkCompileTask;
    }

    @Override
    public Task getObfuscation() {
        return this.getVariantData().obfuscationTask;
    }

    @Override
    public File getMappingFile() {
        return this.getVariantData().getMappingFile();
    }

    public Sync getProcessJavaResources() {
        return this.getVariantData().processJavaResourcesTask;
    }

    @Override
    public Task getAssemble() {
        return this.getVariantData().assembleVariantTask;
    }

    @Override
    public void addJavaSourceFoldersToModel(File ... generatedSourceFolders) {
        this.getVariantData().addJavaSourceFoldersToModel(generatedSourceFolders);
    }

    @Override
    public void addJavaSourceFoldersToModel(Collection<File> generatedSourceFolders) {
        this.getVariantData().addJavaSourceFoldersToModel(generatedSourceFolders);
    }

    @Override
    public void registerJavaGeneratingTask(Task task, File ... sourceFolders) {
        this.getVariantData().registerJavaGeneratingTask(task, sourceFolders);
    }

    @Override
    public void registerJavaGeneratingTask(Task task, Collection<File> sourceFolders) {
        this.getVariantData().registerJavaGeneratingTask(task, sourceFolders);
    }

    @Override
    public void registerResGeneratingTask(Task task, File ... generatedResFolders) {
        this.getVariantData().registerResGeneratingTask(task, generatedResFolders);
    }

    @Override
    public void registerResGeneratingTask(Task task, Collection<File> generatedResFolders) {
        this.getVariantData().registerResGeneratingTask(task, generatedResFolders);
    }

    @Override
    public void buildConfigField(String type, String name, String value) {
        this.getVariantData().getVariantConfiguration().addBuildConfigField(type, name, value);
    }

    @Override
    public void resValue(String type, String name, String value) {
        this.getVariantData().getVariantConfiguration().addResValue(type, name, value);
    }

    @Override
    public void setOutputsAreSigned(boolean isSigned) {
        this.getVariantData().outputsAreSigned = isSigned;
    }

    @Override
    public boolean getOutputsAreSigned() {
        return this.getVariantData().outputsAreSigned;
    }
}

