/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.builder.dependency.ManifestDependency;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ManifestDependencyImpl
implements ManifestDependency {
    private final File manifest;
    private final List<ManifestDependencyImpl> dependencies;
    private final String name;

    public ManifestDependencyImpl(File manifest, List<ManifestDependencyImpl> dependencies) {
        this.manifest = manifest;
        this.dependencies = dependencies;
        this.name = manifest.getName();
    }

    public ManifestDependencyImpl(String name, File manifest, List<ManifestDependencyImpl> dependencies) {
        this.manifest = manifest;
        this.dependencies = dependencies;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public File getManifest() {
        return this.manifest;
    }

    public List<? extends ManifestDependency> getManifestDependencies() {
        return this.dependencies;
    }

    public List<ManifestDependencyImpl> getManifestDependenciesForInput() {
        return this.dependencies;
    }

    public List<File> getAllManifests() {
        ArrayList files = Lists.newArrayListWithExpectedSize((int)(1 + this.dependencies.size() * 2));
        files.add(this.manifest);
        for (ManifestDependencyImpl manifestDep : this.dependencies) {
            files.addAll(manifestDep.getAllManifests());
        }
        return files;
    }
}

