/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.incremental;

import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.incremental.InstantRunWrapperTask;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.BaseTask;
import com.android.utils.FileUtils;
import com.google.common.io.Files;
import java.io.File;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public class BuildInfoLoaderTask
extends BaseTask {
    @OutputDirectory
    File pastBuildsFolder;
    @Input
    String buildId;
    @InputFile
    @Optional
    File buildInfoFile;
    @InputFile
    @Optional
    File tmpBuildInfoFile;
    Logger logger;
    InstantRunBuildContext instantRunBuildContext;

    @TaskAction
    public void executeAction() {
        try {
            if (this.buildInfoFile.exists()) {
                this.instantRunBuildContext.loadFromXmlFile(this.buildInfoFile);
            }
            if (this.tmpBuildInfoFile.exists()) {
                this.instantRunBuildContext.mergeFromFile(this.tmpBuildInfoFile);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Exception while loading build-info.xml : %s", e.getMessage()));
        }
        try {
            InstantRunBuildContext.Build lastBuild = this.instantRunBuildContext.getLastBuild();
            if (lastBuild == null) {
                return;
            }
            File backupFolder = new File(this.pastBuildsFolder, String.valueOf(lastBuild.getBuildId()));
            FileUtils.mkdirs((File)backupFolder);
            for (InstantRunBuildContext.Artifact artifact : lastBuild.getArtifacts()) {
                if (artifact.isAccumulative()) continue;
                File oldLocation = artifact.getLocation();
                if (!oldLocation.isFile()) {
                    return;
                }
                File newLocation = new File(backupFolder, oldLocation.getName());
                if (this.logger.isEnabled(LogLevel.DEBUG)) {
                    this.logger.debug(String.format("File moved from %1$s to %2$s", oldLocation.getPath(), newLocation.getPath()));
                }
                Files.copy((File)oldLocation, (File)newLocation);
                artifact.setLocation(newLocation);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Exception while doing past iteration backup : %s", e.getMessage()));
        }
    }

    public static class ConfigAction
    implements TaskConfigAction<BuildInfoLoaderTask> {
        private final String taskName;
        private final VariantScope variantScope;
        private final Logger logger;

        public ConfigAction(VariantScope scope, Logger logger) {
            this.taskName = scope.getTaskName("buildInfo", "Loader");
            this.variantScope = scope;
            this.logger = logger;
        }

        @Override
        public String getName() {
            return this.taskName;
        }

        @Override
        public Class<BuildInfoLoaderTask> getType() {
            return BuildInfoLoaderTask.class;
        }

        @Override
        public void execute(BuildInfoLoaderTask task) {
            task.setDescription("InstantRun task to load and backup previous iterations artifacts");
            task.setVariantName(this.variantScope.getVariantConfiguration().getFullName());
            this.variantScope.getInstantRunBuildContext().setTmpBuildInfo(InstantRunWrapperTask.ConfigAction.getTmpBuildInfoFile(this.variantScope));
            task.buildInfoFile = InstantRunWrapperTask.ConfigAction.getBuildInfoFile(this.variantScope);
            task.tmpBuildInfoFile = InstantRunWrapperTask.ConfigAction.getTmpBuildInfoFile(this.variantScope);
            task.pastBuildsFolder = this.variantScope.getInstantRunPastIterationsFolder();
            task.instantRunBuildContext = this.variantScope.getInstantRunBuildContext();
            task.logger = this.logger;
            task.buildId = String.valueOf(task.instantRunBuildContext.getBuildId());
        }
    }
}

