/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.incremental;

import com.android.build.gradle.internal.incremental.ByteCodeUtils;
import com.android.build.gradle.internal.incremental.ConstructorArgsRedirection;
import com.android.build.gradle.internal.incremental.ConstructorDelegationDetector;
import com.android.build.gradle.internal.incremental.IncrementalVisitor;
import com.android.build.gradle.internal.incremental.InstantRunMethodVerifier;
import com.android.build.gradle.internal.incremental.InstantRunVerifierStatus;
import com.android.build.gradle.internal.incremental.MethodRedirection;
import com.android.build.gradle.internal.incremental.Redirection;
import com.android.build.gradle.internal.incremental.StringSwitch;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodNode;

public class IncrementalSupportVisitor
extends IncrementalVisitor {
    private boolean disableRedirectionForClass = false;
    public static final IncrementalVisitor.VisitorBuilder VISITOR_BUILDER = new VisitorBuilder();

    public IncrementalSupportVisitor(ClassNode classNode, List<ClassNode> parentNodes, ClassVisitor classVisitor) {
        super(classNode, parentNodes, classVisitor);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.visitedClassName = name;
        this.visitedSuperName = superName;
        super.visitField(4169, "$change", IncrementalSupportVisitor.getRuntimeTypeName(CHANGE_TYPE), null, null);
        access = IncrementalSupportVisitor.transformClassAccessForInstantRun(access);
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (desc.equals(DISABLE_ANNOTATION_TYPE.getDescriptor())) {
            this.disableRedirectionForClass = true;
        }
        return super.visitAnnotation(desc, visible);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        access = IncrementalSupportVisitor.transformAccessForInstantRun(access);
        return super.visitField(access, name, desc, signature, value);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        boolean hasIncompatibleChange;
        access = IncrementalSupportVisitor.transformAccessForInstantRun(access);
        MethodVisitor defaultVisitor = super.visitMethod(access, name, desc, signature, exceptions);
        MethodNode method = IncrementalSupportVisitor.getMethodByNameInClass(name, desc, this.classNode);
        boolean bl = hasIncompatibleChange = InstantRunMethodVerifier.verifyMethod(method) != InstantRunVerifierStatus.COMPATIBLE;
        if (hasIncompatibleChange || this.disableRedirectionForClass || !IncrementalSupportVisitor.isAccessCompatibleWithInstantRun(access) || name.equals("<clinit>")) {
            return defaultVisitor;
        }
        ISMethodVisitor mv = new ISMethodVisitor(defaultVisitor, access, name, desc);
        if (name.equals("<init>")) {
            ConstructorDelegationDetector.Constructor constructor = ConstructorDelegationDetector.deconstruct(this.visitedClassName, method);
            LabelNode start = new LabelNode();
            LabelNode after = new LabelNode();
            method.instructions.insert((AbstractInsnNode)constructor.loadThis, (AbstractInsnNode)start);
            if (constructor.lineForLoad != -1) {
                method.instructions.insert((AbstractInsnNode)constructor.loadThis, (AbstractInsnNode)new LineNumberNode(constructor.lineForLoad, start));
            }
            method.instructions.insert((AbstractInsnNode)constructor.delegation, (AbstractInsnNode)after);
            mv.addRedirection(new ConstructorArgsRedirection(start, this.visitedClassName, constructor.args.name + "." + constructor.args.desc, after, Type.getArgumentTypes((String)constructor.delegation.desc)));
            mv.addRedirection(new MethodRedirection(after, constructor.body.name + "." + constructor.body.desc, Type.getReturnType((String)desc)));
        } else {
            mv.addRedirection(new MethodRedirection(new LabelNode(mv.getStartLabel()), name + "." + desc, Type.getReturnType((String)desc)));
        }
        method.accept((MethodVisitor)mv);
        return null;
    }

    private static int transformClassAccessForInstantRun(int access) {
        IncrementalVisitor.AccessRight accessRight = IncrementalVisitor.AccessRight.fromNodeAccess(access);
        return accessRight == IncrementalVisitor.AccessRight.PACKAGE_PRIVATE ? access | 1 : access;
    }

    private static int transformAccessForInstantRun(int access) {
        IncrementalVisitor.AccessRight accessRight = IncrementalVisitor.AccessRight.fromNodeAccess(access);
        if (accessRight != IncrementalVisitor.AccessRight.PRIVATE) {
            access &= 0xFFFFFFFB;
            return (access &= 0xFFFFFFFD) | 1;
        }
        return access;
    }

    private void createAccessSuper() {
        int access = 4233;
        Method m = new Method("access$super", "(L" + this.visitedClassName + ";Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/Object;");
        MethodVisitor visitor = super.visitMethod(access, m.getName(), m.getDescriptor(), null, null);
        final GeneratorAdapter mv = new GeneratorAdapter(access, m, visitor);
        final HashMap<String, MethodReference> uniqueMethods = new HashMap<String, MethodReference>();
        if (this.parentNodes.isEmpty()) {
            IncrementalSupportVisitor.addAllNewMethods(uniqueMethods, this.classNode);
        } else {
            for (ClassNode parentNode : this.parentNodes) {
                IncrementalSupportVisitor.addAllNewMethods(uniqueMethods, parentNode);
            }
        }
        new StringSwitch(){

            @Override
            void visitString() {
                mv.visitVarInsn(25, 1);
            }

            @Override
            void visitCase(String methodName) {
                MethodReference methodRef = (MethodReference)uniqueMethods.get(methodName);
                mv.visitVarInsn(25, 0);
                Type[] args = Type.getArgumentTypes((String)methodRef.method.desc);
                int argc = 0;
                for (Type t : args) {
                    mv.visitVarInsn(25, 2);
                    mv.push(argc);
                    mv.visitInsn(50);
                    ByteCodeUtils.unbox(mv, t);
                    ++argc;
                }
                if (IncrementalVisitor.TRACING_ENABLED) {
                    IncrementalVisitor.trace(mv, "super selected ", methodRef.owner.name, methodRef.method.name, methodRef.method.desc);
                }
                mv.visitMethodInsn(183, methodRef.owner.name, methodRef.method.name, methodRef.method.desc, false);
                Type ret = Type.getReturnType((String)methodRef.method.desc);
                if (ret.getSort() == 0) {
                    mv.visitInsn(1);
                } else {
                    mv.box(ret);
                }
                mv.visitInsn(176);
            }

            @Override
            void visitDefault() {
                this.writeMissingMessageWithHash(mv, IncrementalSupportVisitor.this.visitedClassName);
            }
        }.visit(mv, uniqueMethods.keySet());
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void createDispatchingThis() {
        final HashMap<String, MethodNode> uniqueMethods = new HashMap<String, MethodNode>();
        this.addAllNewConstructors(uniqueMethods, this.classNode, true);
        for (ClassNode parentNode : this.parentNodes) {
            this.addAllNewConstructors(uniqueMethods, parentNode, false);
        }
        int access = 4097;
        Method m = new Method("<init>", ConstructorArgsRedirection.DISPATCHING_THIS_SIGNATURE);
        MethodVisitor visitor = super.visitMethod(0, m.getName(), m.getDescriptor(), null, null);
        final GeneratorAdapter mv = new GeneratorAdapter(access, m, visitor);
        mv.visitCode();
        Label label = new Label();
        mv.visitLineNumber(0, label);
        mv.visitVarInsn(25, 1);
        mv.push(0);
        mv.visitInsn(50);
        mv.unbox(Type.getType((String)"Ljava/lang/String;"));
        final int constructorCanonicalName = mv.newLocal(Type.getType((String)"Ljava/lang/String;"));
        mv.storeLocal(constructorCanonicalName);
        new StringSwitch(){

            @Override
            void visitString() {
                mv.loadLocal(constructorCanonicalName);
            }

            @Override
            void visitCase(String canonicalName) {
                MethodNode methodNode = (MethodNode)uniqueMethods.get(canonicalName);
                String owner = canonicalName.split("\\.")[0];
                mv.visitVarInsn(25, 0);
                Type[] args = Type.getArgumentTypes((String)methodNode.desc);
                int argc = 0;
                for (Type t : args) {
                    mv.visitVarInsn(25, 1);
                    mv.push(argc + 1);
                    mv.visitInsn(50);
                    ByteCodeUtils.unbox(mv, t);
                    ++argc;
                }
                mv.visitMethodInsn(183, owner, "<init>", methodNode.desc, false);
                mv.visitInsn(177);
            }

            @Override
            void visitDefault() {
                this.writeMissingMessageWithHash(mv, IncrementalSupportVisitor.this.visitedClassName);
            }
        }.visit(mv, uniqueMethods.keySet());
        mv.visitMaxs(1, 3);
        mv.visitEnd();
    }

    public void visitEnd() {
        this.createAccessSuper();
        this.createDispatchingThis();
        super.visitEnd();
    }

    private static void addAllNewMethods(Map<String, MethodReference> methods, ClassNode classNode) {
        for (MethodNode method : classNode.methods) {
            if (method.name.equals("<init>") || method.name.equals("<clinit>")) continue;
            String name = method.name + "." + method.desc;
            if (!IncrementalSupportVisitor.isAccessCompatibleWithInstantRun(method.access) || methods.containsKey(name) || (method.access & 8) != 0 || (method.access & 2) != 0) continue;
            methods.put(name, new MethodReference(method, classNode));
        }
    }

    private void addAllNewConstructors(Map<String, MethodNode> methods, ClassNode classNode, boolean keepPrivateConstructors) {
        for (MethodNode method : classNode.methods) {
            String key;
            if (!method.name.equals("<init>") || !IncrementalSupportVisitor.isAccessCompatibleWithInstantRun(method.access) || !keepPrivateConstructors && (method.access & 2) != 0 || !classNode.name.equals(this.visitedClassName) && !classNode.name.equals(this.visitedSuperName) || methods.containsKey(key = classNode.name + "." + method.desc)) continue;
            methods.put(key, method);
        }
    }

    public static void main(String[] args) throws IOException {
        IncrementalVisitor.main(args, VISITOR_BUILDER);
    }

    private static class MethodReference {
        final MethodNode method;
        final ClassNode owner;

        private MethodReference(MethodNode method, ClassNode owner) {
            this.method = method;
            this.owner = owner;
        }
    }

    private class ISMethodVisitor
    extends GeneratorAdapter {
        private boolean disableRedirection;
        private int change;
        private final List<Type> args;
        private final List<Redirection> redirections;
        private final Map<Label, Redirection> resolvedRedirections;
        private final Label start;

        public ISMethodVisitor(MethodVisitor mv, int access, String name, String desc) {
            boolean isStatic;
            super(327680, mv, access, name, desc);
            this.disableRedirection = false;
            this.change = -1;
            this.redirections = new ArrayList<Redirection>();
            this.resolvedRedirections = new HashMap<Label, Redirection>();
            this.args = new ArrayList<Type>(Arrays.asList(Type.getArgumentTypes((String)desc)));
            this.start = new Label();
            boolean bl = isStatic = (access & 8) != 0;
            if (!isStatic) {
                this.args.add(0, Type.getType(Object.class));
            }
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (desc.equals(IncrementalVisitor.DISABLE_ANNOTATION_TYPE.getDescriptor())) {
                this.disableRedirection = true;
            }
            return super.visitAnnotation(desc, visible);
        }

        public void visitCode() {
            if (!this.disableRedirection) {
                for (Redirection redirection : this.redirections) {
                    this.resolvedRedirections.put(redirection.getPosition().getLabel(), redirection);
                }
                super.visitLabel(this.start);
                this.change = this.newLocal(IncrementalVisitor.CHANGE_TYPE);
                this.visitFieldInsn(178, IncrementalSupportVisitor.this.visitedClassName, "$change", IncrementalVisitor.getRuntimeTypeName(IncrementalVisitor.CHANGE_TYPE));
                this.storeLocal(this.change);
                this.redirectAt(this.start);
            }
            super.visitCode();
        }

        public void visitLabel(Label label) {
            super.visitLabel(label);
            this.redirectAt(label);
        }

        private void redirectAt(Label label) {
            if (this.disableRedirection) {
                return;
            }
            Redirection redirection = this.resolvedRedirections.get(label);
            if (redirection != null) {
                super.visitLineNumber(0, label);
                redirection.redirect(this, this.change, this.args);
            }
        }

        public void addRedirection(Redirection redirection) {
            this.redirections.add(redirection);
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            if (!this.disableRedirection && index < this.args.size()) {
                start = this.start;
            }
            super.visitLocalVariable(name, desc, signature, start, end, index);
        }

        public Label getStartLabel() {
            return this.start;
        }
    }

    private static final class VisitorBuilder
    implements IncrementalVisitor.VisitorBuilder {
        private VisitorBuilder() {
        }

        @Override
        public IncrementalVisitor build(ClassNode classNode, List<ClassNode> parentNodes, ClassVisitor classVisitor) {
            return new IncrementalSupportVisitor(classNode, parentNodes, classVisitor);
        }

        @Override
        public String getMangledRelativeClassFilePath(String originalClassFilePath) {
            return originalClassFilePath;
        }

        @Override
        public IncrementalVisitor.OutputType getOutputType() {
            return IncrementalVisitor.OutputType.INSTRUMENT;
        }
    }
}

