/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.incremental;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

abstract class StringSwitch {
    static Function<String, Integer> hashMethod = new Function<String, Integer>(){

        public Integer apply(String input) {
            return input.hashCode();
        }
    };
    private static final Integer FORCE_HASH_COLLISION_MODULUS = null;
    private static final Type OBJECT_TYPE = Type.getType(Object.class);
    private static final Type STRING_TYPE = Type.getType(String.class);
    private static final Type INSTANT_RELOAD_EXCEPTION_TYPE = Type.getType((String)"com/android/tools/fd/runtime/InstantReloadException");

    StringSwitch() {
    }

    abstract void visitString();

    abstract void visitCase(String var1);

    abstract void visitDefault();

    void visitHashMethod(GeneratorAdapter mv) {
        mv.invokeVirtual(STRING_TYPE, Method.getMethod((String)"int hashCode()"));
    }

    private void visitx(GeneratorAdapter mv, List<String> strings) {
        if (strings.size() == 1) {
            this.visitCase(strings.get(0));
            return;
        }
        for (int i = 0; i < strings.size(); ++i) {
            String string = strings.get(i);
            Label label = new Label();
            this.visitString();
            mv.visitLdcInsn((Object)string);
            mv.invokeVirtual(STRING_TYPE, Method.getMethod((String)"boolean equals(Object)"));
            mv.visitJumpInsn(153, label);
            this.visitCase(string);
            mv.visitLabel(label);
        }
        this.visitDefault();
    }

    private void visitClassifier(GeneratorAdapter mv, Set<String> strings) {
        int i;
        this.visitString();
        this.visitHashMethod(mv);
        ImmutableListMultimap buckets = Multimaps.index(strings, hashMethod);
        ImmutableList sorted = Ordering.natural().onResultOf((Function)new Function<Map.Entry<Integer, Collection<String>>, Integer>(){

            public Integer apply(Map.Entry<Integer, Collection<String>> entry) {
                return entry.getKey();
            }
        }).immutableSortedCopy(buckets.asMap().entrySet());
        int[] sortedHashes = new int[sorted.size()];
        List[] sortedCases = new List[sorted.size()];
        int index = 0;
        for (Map.Entry entry : sorted) {
            sortedHashes[index] = (Integer)entry.getKey();
            sortedCases[index] = Lists.newCopyOnWriteArrayList((Iterable)((Iterable)entry.getValue()));
            ++index;
        }
        Label[] labels = new Label[sorted.size()];
        Label defaultLabel = new Label();
        for (i = 0; i < sorted.size(); ++i) {
            labels[i] = new Label();
        }
        mv.visitLookupSwitchInsn(defaultLabel, sortedHashes, labels);
        for (i = 0; i < sorted.size(); ++i) {
            mv.visitLabel(labels[i]);
            this.visitx(mv, sortedCases[i]);
        }
        mv.visitLabel(defaultLabel);
        this.visitDefault();
    }

    void writeMissingMessageWithHash(GeneratorAdapter mv, String visitedClassName) {
        mv.newInstance(INSTANT_RELOAD_EXCEPTION_TYPE);
        mv.dup();
        mv.push("String switch could not find '%s' with hashcode %s in %s");
        mv.push(3);
        mv.newArray(OBJECT_TYPE);
        mv.dup();
        mv.push(0);
        this.visitString();
        mv.arrayStore(OBJECT_TYPE);
        mv.dup();
        mv.push(1);
        this.visitString();
        this.visitHashMethod(mv);
        mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
        mv.arrayStore(OBJECT_TYPE);
        mv.dup();
        mv.push(2);
        mv.push(visitedClassName);
        mv.arrayStore(OBJECT_TYPE);
        mv.visitMethodInsn(184, "java/lang/String", "format", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", false);
        mv.invokeConstructor(INSTANT_RELOAD_EXCEPTION_TYPE, Method.getMethod((String)"void <init> (String)"));
        mv.throwException();
    }

    void visit(GeneratorAdapter mv, Set<String> strings) {
        this.visitClassifier(mv, strings);
    }
}

