/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.model;

import com.android.build.gradle.internal.ProductFlavorData;
import com.android.build.gradle.internal.api.DefaultAndroidSourceSet;
import com.android.build.gradle.internal.model.ProductFlavorImpl;
import com.android.build.gradle.internal.model.SourceProviderContainerImpl;
import com.android.build.gradle.internal.model.SourceProviderImpl;
import com.android.builder.core.VariantType;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.SourceProviderContainer;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

class ProductFlavorContainerImpl
implements ProductFlavorContainer,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ProductFlavor productFlavor;
    private final SourceProvider sourceProvider;
    private final Collection<SourceProviderContainer> extraSourceProviders;

    static ProductFlavorContainer createProductFlavorContainer(ProductFlavorData productFlavorData, Collection<SourceProviderContainer> sourceProviderContainers) {
        List<SourceProviderContainer> clonedContainers = SourceProviderContainerImpl.cloneCollection(sourceProviderContainers);
        for (VariantType variantType : VariantType.getTestingTypes()) {
            DefaultAndroidSourceSet sourceSet = productFlavorData.getTestSourceSet(variantType);
            if (sourceSet == null) continue;
            clonedContainers.add(SourceProviderContainerImpl.create(variantType.getArtifactName(), sourceSet));
        }
        return new ProductFlavorContainerImpl(ProductFlavorImpl.cloneFlavor(productFlavorData.getProductFlavor(), null, null), SourceProviderImpl.cloneProvider(productFlavorData.getSourceSet()), clonedContainers);
    }

    private ProductFlavorContainerImpl(ProductFlavorImpl productFlavor, SourceProviderImpl sourceProvider, Collection<SourceProviderContainer> extraSourceProviders) {
        this.productFlavor = productFlavor;
        this.sourceProvider = sourceProvider;
        this.extraSourceProviders = extraSourceProviders;
    }

    public ProductFlavor getProductFlavor() {
        return this.productFlavor;
    }

    public SourceProvider getSourceProvider() {
        return this.sourceProvider;
    }

    public Collection<SourceProviderContainer> getExtraSourceProviders() {
        return this.extraSourceProviders;
    }
}

