/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.model;

import com.android.build.gradle.internal.model.ApiVersionImpl;
import com.android.build.gradle.internal.model.BaseConfigImpl;
import com.android.builder.core.DefaultVectorDrawablesOptions;
import com.android.builder.model.ApiVersion;
import com.android.builder.model.BaseConfig;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.SigningConfig;
import com.android.builder.model.VectorDrawablesOptions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

class ProductFlavorImpl
extends BaseConfigImpl
implements ProductFlavor,
Serializable {
    private static final long serialVersionUID = 1L;
    private String name = null;
    private String mDimension = null;
    private ApiVersion mMinSdkVersion = null;
    private ApiVersion mTargetSdkVersion = null;
    private Integer mMaxSdkVersion = null;
    private Integer mRenderscriptTargetApi = null;
    private Boolean mRenderscriptSupportMode = null;
    private Boolean mRenderscriptNdkMode = null;
    private Integer mVersionCode = null;
    private String mVersionName = null;
    private String mApplicationId = null;
    private String mTestApplicationId = null;
    private String mTestInstrumentationRunner = null;
    private Map<String, String> mTestInstrumentationRunnerArguments = Maps.newHashMap();
    private Boolean mTestHandleProfiling = null;
    private Boolean mTestFunctionalTest = null;
    private Set<String> mResourceConfigurations = null;
    private DefaultVectorDrawablesOptions mVectorDrawablesOptions = null;

    static ProductFlavorImpl cloneFlavor(ProductFlavor productFlavor, ApiVersion minSdkVersionOverride, ApiVersion targetSdkVersionOverride) {
        ProductFlavorImpl clonedFlavor = new ProductFlavorImpl(productFlavor);
        clonedFlavor.name = productFlavor.getName();
        clonedFlavor.mDimension = productFlavor.getDimension();
        clonedFlavor.mMinSdkVersion = minSdkVersionOverride != null ? minSdkVersionOverride : ApiVersionImpl.clone(productFlavor.getMinSdkVersion());
        clonedFlavor.mTargetSdkVersion = targetSdkVersionOverride != null ? targetSdkVersionOverride : ApiVersionImpl.clone(productFlavor.getTargetSdkVersion());
        clonedFlavor.mMaxSdkVersion = targetSdkVersionOverride != null ? null : productFlavor.getMaxSdkVersion();
        clonedFlavor.mRenderscriptTargetApi = productFlavor.getRenderscriptTargetApi();
        clonedFlavor.mRenderscriptSupportMode = productFlavor.getRenderscriptSupportModeEnabled();
        clonedFlavor.mRenderscriptNdkMode = productFlavor.getRenderscriptNdkModeEnabled();
        clonedFlavor.mVersionCode = productFlavor.getVersionCode();
        clonedFlavor.mVersionName = productFlavor.getVersionName();
        clonedFlavor.mApplicationId = productFlavor.getApplicationId();
        clonedFlavor.mTestApplicationId = productFlavor.getTestApplicationId();
        clonedFlavor.mTestInstrumentationRunner = productFlavor.getTestInstrumentationRunner();
        clonedFlavor.mTestHandleProfiling = productFlavor.getTestHandleProfiling();
        clonedFlavor.mTestFunctionalTest = productFlavor.getTestFunctionalTest();
        clonedFlavor.mResourceConfigurations = ImmutableSet.copyOf((Collection)productFlavor.getResourceConfigurations());
        clonedFlavor.mTestInstrumentationRunnerArguments = Maps.newHashMap((Map)productFlavor.getTestInstrumentationRunnerArguments());
        clonedFlavor.mVectorDrawablesOptions = DefaultVectorDrawablesOptions.copyOf((VectorDrawablesOptions)productFlavor.getVectorDrawables());
        return clonedFlavor;
    }

    private ProductFlavorImpl(ProductFlavor productFlavor) {
        super((BaseConfig)productFlavor);
    }

    public String getName() {
        return this.name;
    }

    public String getApplicationId() {
        return this.mApplicationId;
    }

    public Integer getVersionCode() {
        return this.mVersionCode;
    }

    public String getVersionName() {
        return this.mVersionName;
    }

    public ApiVersion getMinSdkVersion() {
        return this.mMinSdkVersion;
    }

    public ApiVersion getTargetSdkVersion() {
        return this.mTargetSdkVersion;
    }

    public Integer getMaxSdkVersion() {
        return this.mMaxSdkVersion;
    }

    public Integer getRenderscriptTargetApi() {
        return this.mRenderscriptTargetApi;
    }

    public Boolean getRenderscriptSupportModeEnabled() {
        return this.mRenderscriptSupportMode;
    }

    public Boolean getRenderscriptNdkModeEnabled() {
        return this.mRenderscriptNdkMode;
    }

    public String getTestApplicationId() {
        return this.mTestApplicationId;
    }

    public String getTestInstrumentationRunner() {
        return this.mTestInstrumentationRunner;
    }

    public Map<String, String> getTestInstrumentationRunnerArguments() {
        return this.mTestInstrumentationRunnerArguments;
    }

    public Boolean getTestHandleProfiling() {
        return this.mTestHandleProfiling;
    }

    public Boolean getTestFunctionalTest() {
        return this.mTestFunctionalTest;
    }

    public Collection<String> getResourceConfigurations() {
        return this.mResourceConfigurations;
    }

    public SigningConfig getSigningConfig() {
        return null;
    }

    public VectorDrawablesOptions getVectorDrawables() {
        return this.mVectorDrawablesOptions;
    }

    public String getDimension() {
        return this.mDimension;
    }

    @Override
    public String toString() {
        return "ProductFlavorImpl{name='" + this.name + '\'' + ", mDimension='" + this.mDimension + '\'' + ", mMinSdkVersion=" + this.mMinSdkVersion + ", mTargetSdkVersion=" + this.mTargetSdkVersion + ", mMaxSdkVersion=" + this.mMaxSdkVersion + ", mRenderscriptTargetApi=" + this.mRenderscriptTargetApi + ", mRenderscriptSupportMode=" + this.mRenderscriptSupportMode + ", mRenderscriptNdkMode=" + this.mRenderscriptNdkMode + ", mVersionCode=" + this.mVersionCode + ", mVersionName='" + this.mVersionName + '\'' + ", mApplicationId='" + this.mApplicationId + '\'' + ", mTestApplicationId='" + this.mTestApplicationId + '\'' + ", mTestInstrumentationRunner='" + this.mTestInstrumentationRunner + '\'' + ", mTestHandleProfiling=" + this.mTestHandleProfiling + ", mTestFunctionalTest=" + this.mTestFunctionalTest + ", mResourceConfigurations=" + this.mResourceConfigurations + ", mVectorDrawablesOptions=" + this.mVectorDrawablesOptions + "} " + super.toString();
    }
}

