/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.model;

import com.android.build.gradle.internal.model.SourceProviderImpl;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.SourceProviderContainer;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class SourceProviderContainerImpl
implements SourceProviderContainer,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final SourceProvider sourceProvider;

    static SourceProviderContainer clone(SourceProviderContainer sourceProviderContainer) {
        return SourceProviderContainerImpl.create(sourceProviderContainer.getArtifactName(), sourceProviderContainer.getSourceProvider());
    }

    static List<SourceProviderContainer> cloneCollection(Collection<SourceProviderContainer> containers) {
        ArrayList clones = Lists.newArrayListWithCapacity((int)containers.size());
        for (SourceProviderContainer container : containers) {
            clones.add(SourceProviderContainerImpl.clone(container));
        }
        return clones;
    }

    static SourceProviderContainer create(String name, SourceProvider sourceProvider) {
        return new SourceProviderContainerImpl(name, SourceProviderImpl.cloneProvider(sourceProvider));
    }

    private SourceProviderContainerImpl(String name, SourceProvider sourceProvider) {
        this.name = name;
        this.sourceProvider = sourceProvider;
    }

    public String getArtifactName() {
        return this.name;
    }

    public SourceProvider getSourceProvider() {
        return this.sourceProvider;
    }
}

