/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.pipeline;

import com.android.build.api.transform.Format;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.TransformInput;
import com.android.build.gradle.internal.pipeline.ExtendedContentType;
import com.android.build.gradle.internal.pipeline.ImmutableDirectoryInput;
import com.android.build.gradle.internal.pipeline.ImmutableJarInput;
import com.android.build.gradle.internal.pipeline.ImmutableTransformInput;
import com.android.build.gradle.internal.pipeline.IncrementalTransformInput;
import com.android.build.gradle.internal.pipeline.MutableDirectoryInput;
import com.android.build.gradle.internal.pipeline.QualifiedContentImpl;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class IntermediateFolderUtils {
    public static final String FOLDERS = "folders";
    public static final String JARS = "jars";

    public static File getContentLocation(File rootLocation, String name, Set<QualifiedContent.ContentType> types, Set<QualifiedContent.Scope> scopes, Format format) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull(types);
        Preconditions.checkNotNull(scopes);
        Preconditions.checkNotNull((Object)format);
        Preconditions.checkState((!name.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkState((!types.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkState((!scopes.isEmpty() ? 1 : 0) != 0);
        switch (format) {
            case DIRECTORY: {
                File location = FileUtils.join((File)rootLocation, (String[])new String[]{FOLDERS, IntermediateFolderUtils.typesToString(types), IntermediateFolderUtils.scopesToString(scopes), name});
                return location;
            }
            case JAR: {
                File location = FileUtils.join((File)rootLocation, (String[])new String[]{JARS, IntermediateFolderUtils.typesToString(types), IntermediateFolderUtils.scopesToString(scopes), name + ".jar"});
                return location;
            }
        }
        throw new RuntimeException("Unexpected Format: " + format);
    }

    public static TransformInput computeNonIncrementalInputFromFolder(File folder, Set<QualifiedContent.ContentType> requiredTypes, Set<QualifiedContent.Scope> requiredScopes) {
        File foldersFolder;
        final ArrayList jarInputs = Lists.newArrayList();
        final ArrayList directoryInputs = Lists.newArrayList();
        File jarsFolder = new File(folder, JARS);
        if (jarsFolder.isDirectory()) {
            IntermediateFolderUtils.parseTypeLevelFolders(jarsFolder, requiredTypes, requiredScopes, new InputGenerator(){

                @Override
                public boolean accept(File file) {
                    return file.isFile() && file.getName().endsWith(".jar");
                }

                @Override
                public void generate(File file, Set<QualifiedContent.ContentType> types, Set<QualifiedContent.Scope> scopes) {
                    jarInputs.add(new ImmutableJarInput(file.getName().substring(0, file.getName().length() - ".jar".length()), file, Status.NOTCHANGED, types, scopes));
                }
            });
        }
        if ((foldersFolder = new File(folder, FOLDERS)).isDirectory()) {
            IntermediateFolderUtils.parseTypeLevelFolders(foldersFolder, requiredTypes, requiredScopes, new InputGenerator(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory();
                }

                @Override
                public void generate(File file, Set<QualifiedContent.ContentType> types, Set<QualifiedContent.Scope> scopes) {
                    directoryInputs.add(new ImmutableDirectoryInput(file.getName(), file, types, scopes));
                }
            });
        }
        return new ImmutableTransformInput(jarInputs, directoryInputs, folder);
    }

    public static IncrementalTransformInput computeIncrementalInputFromFolder(File rootLocation, Set<QualifiedContent.ContentType> requiredTypes, Set<QualifiedContent.Scope> requiredScopes) {
        File foldersFolder;
        final IntermediateTransformInput input = new IntermediateTransformInput(rootLocation);
        File jarsFolder = new File(rootLocation, JARS);
        if (jarsFolder.isDirectory()) {
            IntermediateFolderUtils.parseTypeLevelFolders(jarsFolder, requiredTypes, requiredScopes, new InputGenerator(){

                @Override
                public boolean accept(File file) {
                    return file.isFile() && file.getName().endsWith(".jar");
                }

                @Override
                public void generate(File file, Set<QualifiedContent.ContentType> types, Set<QualifiedContent.Scope> scopes) {
                    input.addJarInput(new QualifiedContentImpl(file.getName().substring(0, file.getName().length() - ".jar".length()), file, types, scopes){});
                }
            });
        }
        if ((foldersFolder = new File(rootLocation, FOLDERS)).isDirectory()) {
            IntermediateFolderUtils.parseTypeLevelFolders(foldersFolder, requiredTypes, requiredScopes, new InputGenerator(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory();
                }

                @Override
                public void generate(File file, Set<QualifiedContent.ContentType> types, Set<QualifiedContent.Scope> scopes) {
                    input.addFolderInput(new MutableDirectoryInput(file.getName(), file, types, scopes));
                }
            });
        }
        return input;
    }

    private static void parseTypeLevelFolders(File rootFolder, Set<QualifiedContent.ContentType> requiredTypes, Set<QualifiedContent.Scope> requiredScopes, InputGenerator generator) {
        File[] files = rootFolder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        if (files != null && files.length > 0) {
            for (File file : files) {
                Sets.SetView limitedTypes;
                Set<QualifiedContent.ContentType> types = IntermediateFolderUtils.stringToTypes(file.getName());
                if (types == null || (limitedTypes = Sets.intersection(requiredTypes, types)).isEmpty()) continue;
                IntermediateFolderUtils.parseScopeLevelFolders(file, (Set<QualifiedContent.ContentType>)limitedTypes, requiredScopes, generator);
            }
        }
    }

    private static void parseScopeLevelFolders(File rootFolder, Set<QualifiedContent.ContentType> types, Set<QualifiedContent.Scope> requiredScopes, InputGenerator generator) {
        File[] files = rootFolder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        if (files != null && files.length > 0) {
            for (File file : files) {
                Set<QualifiedContent.Scope> scopes = IntermediateFolderUtils.stringToScopes(file.getName());
                if (scopes == null) continue;
                HashSet limitedScopes = Sets.newHashSetWithExpectedSize((int)requiredScopes.size());
                boolean foundUnwanted = false;
                for (QualifiedContent.Scope scope : scopes) {
                    if (requiredScopes.contains(scope)) {
                        limitedScopes.add(scope);
                        continue;
                    }
                    foundUnwanted = true;
                }
                if (limitedScopes.isEmpty()) continue;
                if (foundUnwanted) {
                    throw new RuntimeException("error");
                }
                IntermediateFolderUtils.parseContentLevelFolders(file, types, (Set<QualifiedContent.Scope>)Sets.immutableEnumSet((Iterable)limitedScopes), generator);
            }
        }
    }

    private static void parseContentLevelFolders(File rootFolder, Set<QualifiedContent.ContentType> types, Set<QualifiedContent.Scope> scopes, final InputGenerator generator) {
        File[] files = rootFolder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return generator.accept(file);
            }
        });
        if (files != null && files.length > 0) {
            for (File file : files) {
                generator.generate(file, types, scopes);
            }
        }
    }

    private static Set<QualifiedContent.ContentType> stringToTypes(String folderName) {
        int value;
        try {
            value = Integer.parseInt(folderName, 16);
        }
        catch (NumberFormatException e) {
            return null;
        }
        ImmutableSet.Builder typesBuilder = ImmutableSet.builder();
        for (QualifiedContent.ContentType type : ExtendedContentType.getAllContentTypes()) {
            if ((type.getValue() & value) == 0) continue;
            typesBuilder.add((Object)type);
        }
        ImmutableSet types = typesBuilder.build();
        if (types.isEmpty()) {
            return null;
        }
        return types;
    }

    private static String typesToString(Set<QualifiedContent.ContentType> types) {
        int value = 0;
        for (QualifiedContent.ContentType type : types) {
            value += type.getValue();
        }
        return String.format("%x", value);
    }

    private static Set<QualifiedContent.Scope> stringToScopes(String folderName) {
        int value;
        try {
            value = Integer.parseInt(folderName, 16);
        }
        catch (NumberFormatException e) {
            return null;
        }
        HashSet scopes = Sets.newHashSet();
        for (QualifiedContent.Scope scope : QualifiedContent.Scope.values()) {
            if ((scope.getValue() & value) == 0) continue;
            scopes.add(scope);
        }
        if (scopes.isEmpty()) {
            return null;
        }
        return Sets.immutableEnumSet((Iterable)scopes);
    }

    private static String scopesToString(Set<QualifiedContent.Scope> scopes) {
        int value = 0;
        for (QualifiedContent.Scope scope : scopes) {
            value += scope.getValue();
        }
        return String.format("%x", value);
    }

    private static interface InputGenerator {
        public boolean accept(File var1);

        public void generate(File var1, Set<QualifiedContent.ContentType> var2, Set<QualifiedContent.Scope> var3);
    }

    static class IntermediateTransformInput
    extends IncrementalTransformInput {
        private final File inputRoot;
        private List<String> rootLocationSegments = null;

        IntermediateTransformInput(File inputRoot) {
            this.inputRoot = inputRoot;
        }

        @Override
        protected boolean checkRemovedFolder(File file, List<String> fileSegments) {
            Set scopes;
            Set types;
            if (!this.checkRootSegments(fileSegments)) {
                return false;
            }
            if (fileSegments.size() <= this.rootLocationSegments.size() + 4) {
                return false;
            }
            int index = this.rootLocationSegments.size();
            if (!fileSegments.get(index++).equals(IntermediateFolderUtils.FOLDERS)) {
                return false;
            }
            if ((types = IntermediateFolderUtils.stringToTypes(fileSegments.get(index++))) == null) {
                return false;
            }
            if ((scopes = IntermediateFolderUtils.stringToScopes(fileSegments.get(index++))) == null) {
                return false;
            }
            String name = fileSegments.get(index);
            File root = new File(FileUtils.join(fileSegments.subList(0, this.rootLocationSegments.size() + 4)));
            MutableDirectoryInput folder = new MutableDirectoryInput(name, root, types, scopes);
            folder.addChangedFile(file, Status.REMOVED);
            this.addFolderInput(folder);
            return true;
        }

        @Override
        boolean checkRemovedJarFile(File file, List<String> fileSegments) {
            Set scopes;
            Set types;
            if (!this.checkRootSegments(fileSegments)) {
                return false;
            }
            if (fileSegments.size() != this.rootLocationSegments.size() + 4) {
                return false;
            }
            if (!file.getPath().endsWith(".jar")) {
                return false;
            }
            int index = this.rootLocationSegments.size();
            if (!fileSegments.get(index++).equals(IntermediateFolderUtils.JARS)) {
                return false;
            }
            if ((types = IntermediateFolderUtils.stringToTypes(fileSegments.get(index++))) == null) {
                return false;
            }
            if ((scopes = IntermediateFolderUtils.stringToScopes(fileSegments.get(index++))) == null) {
                return false;
            }
            String name = fileSegments.get(index);
            this.addImmutableJar(new ImmutableJarInput(name, file, Status.REMOVED, types, scopes));
            return true;
        }

        private boolean checkRootSegments(List<String> fileSegments) {
            if (this.rootLocationSegments == null) {
                this.rootLocationSegments = Lists.newArrayList((Iterable)Splitter.on((char)File.separatorChar).split((CharSequence)this.inputRoot.getAbsolutePath()));
            }
            if (fileSegments.size() <= this.rootLocationSegments.size()) {
                return false;
            }
            for (int i = this.rootLocationSegments.size() - 1; i >= 0; --i) {
                if (this.rootLocationSegments.get(i).equals(fileSegments.get(i))) continue;
                return false;
            }
            return true;
        }
    }
}

