/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.profile;

import com.android.build.gradle.internal.tasks.DefaultAndroidTask;
import com.android.builder.profile.ExecutionRecord;
import com.android.builder.profile.ExecutionType;
import com.android.builder.profile.Recorder;
import com.google.common.base.CaseFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.tasks.TaskState;

public class RecordingBuildListener
implements TaskExecutionListener {
    private final Recorder mRecorder;
    final Map<String, TaskRecord> taskRecords = new ConcurrentHashMap<String, TaskRecord>();

    public RecordingBuildListener(Recorder recorder) {
        this.mRecorder = recorder;
    }

    public void beforeExecute(Task task) {
        this.taskRecords.put(task.getName(), new TaskRecord(this.mRecorder.allocationRecordId(), System.currentTimeMillis()));
    }

    public void afterExecute(Task task, TaskState taskState) {
        ExecutionType executionType;
        String taskImpl = task.getClass().getSimpleName();
        if (taskImpl.endsWith("_Decorated")) {
            taskImpl = taskImpl.substring(0, taskImpl.length() - "_Decorated".length());
        }
        String potentialExecutionTypeName = "TASK_" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, taskImpl);
        try {
            executionType = ExecutionType.valueOf((String)potentialExecutionTypeName);
        }
        catch (IllegalArgumentException ignored) {
            executionType = ExecutionType.GENERIC_TASK_EXECUTION;
        }
        ArrayList<Recorder.Property> properties = new ArrayList<Recorder.Property>();
        properties.add(new Recorder.Property("project", task.getProject().getName()));
        properties.add(new Recorder.Property("task", task.getName()));
        if (task instanceof DefaultAndroidTask) {
            String variantName = ((DefaultAndroidTask)task).getVariantName();
            if (variantName == null) {
                throw new IllegalStateException("Task with type " + task.getClass().getName() + " does not include a variantName");
            }
            if (!variantName.isEmpty()) {
                properties.add(new Recorder.Property("variant", variantName));
            }
        }
        TaskRecord taskRecord = this.taskRecords.get(task.getName());
        this.mRecorder.closeRecord(new ExecutionRecord(taskRecord.recordId, 0L, taskRecord.startTime, System.currentTimeMillis() - taskRecord.startTime, executionType, properties));
    }

    private static final class TaskRecord {
        private final long recordId;
        private final long startTime;

        TaskRecord(long recordId, long startTime) {
            this.startTime = startTime;
            this.recordId = recordId;
        }
    }
}

