/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.dependency.DependencyChecker;
import com.android.build.gradle.internal.tasks.BaseTask;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.builder.model.ApiVersion;
import com.android.builder.model.SyncIssue;
import com.android.sdklib.SdkVersionInfo;
import com.android.utils.StringHelper;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.api.tasks.TaskAction;

@ParallelizableTask
public class PrepareDependenciesTask
extends BaseTask {
    private BaseVariantData variant;
    private final List<DependencyChecker> checkers = Lists.newArrayList();

    @TaskAction
    protected void prepare() {
        ApiVersion minSdkVersion = this.variant.getVariantConfiguration().getMinSdkVersion();
        int minSdk = 1;
        minSdk = minSdkVersion.getCodename() != null ? SdkVersionInfo.getApiByBuildCode((String)minSdkVersion.getCodename(), (boolean)true) : minSdkVersion.getApiLevel();
        boolean foundError = false;
        for (DependencyChecker checker : this.checkers) {
            for (Map.Entry<ModuleVersionIdentifier, Integer> entry : checker.getLegacyApiLevels().entrySet()) {
                ModuleVersionIdentifier mavenVersion = entry.getKey();
                int api = entry.getValue();
                if (api <= minSdk) continue;
                foundError = true;
                String configurationName = checker.getConfigurationDependencies().getName();
                this.getLogger().error("Variant {} has a dependency on version {} of the legacy {} Maven artifact, which corresponds to API level {}. This is not compatible with min SDK of this module, which is {}. Please use the 'gradle dependencies' task to debug your dependencies graph.", new Object[]{StringHelper.capitalize((String)configurationName), mavenVersion.getVersion(), mavenVersion.getGroup(), api, minSdk});
            }
            for (SyncIssue syncIssue : checker.getSyncIssues()) {
                foundError = true;
                this.getLogger().error(syncIssue.getMessage());
            }
        }
        if (foundError) {
            throw new GradleException("Dependency Error. See console for details.");
        }
    }

    public void addChecker(DependencyChecker checker) {
        this.checkers.add(checker);
    }

    public BaseVariantData getVariant() {
        return this.variant;
    }

    public void setVariant(BaseVariantData variant) {
        this.variant = variant;
    }
}

