/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.test;

import com.android.builder.core.VariantConfiguration;
import com.android.builder.model.ApiVersion;
import com.android.builder.testing.TestData;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Locale;
import java.util.Map;

public abstract class AbstractTestDataImpl
implements TestData {
    private final VariantConfiguration<?, ?, ?> testVariantConfig;
    private Map<String, String> extraInstrumentationTestRunnerArgs;

    public AbstractTestDataImpl(VariantConfiguration<?, ?, ?> testVariantConfig) {
        this.testVariantConfig = (VariantConfiguration)Preconditions.checkNotNull(testVariantConfig);
        this.extraInstrumentationTestRunnerArgs = Maps.newHashMap();
    }

    public String getInstrumentationRunner() {
        return this.testVariantConfig.getInstrumentationRunner();
    }

    public Map<String, String> getInstrumentationRunnerArguments() {
        return ImmutableMap.builder().putAll(this.testVariantConfig.getInstrumentationRunnerArguments()).putAll(this.extraInstrumentationTestRunnerArgs).build();
    }

    public void setExtraInstrumentationTestRunnerArgs(Map<String, String> extraInstrumentationTestRunnerArgs) {
        this.extraInstrumentationTestRunnerArgs = ImmutableMap.copyOf(extraInstrumentationTestRunnerArgs);
    }

    public boolean isTestCoverageEnabled() {
        return this.testVariantConfig.isTestCoverageEnabled();
    }

    public ApiVersion getMinSdkVersion() {
        return this.testVariantConfig.getMinSdkVersion();
    }

    public String getFlavorName() {
        return this.testVariantConfig.getFlavorName().toUpperCase(Locale.getDefault());
    }
}

