/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.builder.signing.SignedJarBuilder;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.gradle.api.logging.Logging;

public class JarMerger {
    private final byte[] buffer = new byte[8192];
    private final ILogger logger = new LoggerWrapper(Logging.getLogger(JarMerger.class));
    private final File jarFile;
    private Closer closer;
    private JarOutputStream jarOutputStream;
    private SignedJarBuilder.IZipEntryFilter filter;

    public JarMerger(File jarFile) throws IOException {
        this.jarFile = jarFile;
    }

    private void init() throws IOException {
        if (this.closer == null) {
            FileUtils.mkdirs((File)this.jarFile.getParentFile());
            this.closer = Closer.create();
            FileOutputStream fos = (FileOutputStream)this.closer.register((Closeable)new FileOutputStream(this.jarFile));
            this.jarOutputStream = (JarOutputStream)this.closer.register((Closeable)new JarOutputStream(fos));
        }
    }

    public void setFilter(SignedJarBuilder.IZipEntryFilter filter) {
        this.filter = filter;
    }

    public void addFolder(File folder) throws IOException {
        this.init();
        try {
            this.addFolder(folder, "");
        }
        catch (SignedJarBuilder.IZipEntryFilter.ZipAbortException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFolder(File folder, String path) throws IOException, SignedJarBuilder.IZipEntryFilter.ZipAbortException {
        this.logger.verbose("addFolder(%1$s, %2$s)", new Object[]{folder, path});
        File[] files = folder.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isFile()) {
                    String entryPath = path + file.getName();
                    if (this.filter != null && !this.filter.checkEntry(entryPath)) continue;
                    this.logger.verbose("addFolder(%1$s, %2$s): entry %3$s", new Object[]{folder, path, entryPath});
                    this.jarOutputStream.putNextEntry(new JarEntry(entryPath));
                    Closer localCloser = Closer.create();
                    try {
                        int count;
                        FileInputStream fis = (FileInputStream)localCloser.register((Closeable)new FileInputStream(file));
                        while ((count = fis.read(this.buffer)) != -1) {
                            this.jarOutputStream.write(this.buffer, 0, count);
                        }
                    }
                    finally {
                        localCloser.close();
                    }
                    this.jarOutputStream.closeEntry();
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.addFolder(file, path + file.getName() + "/");
            }
        }
    }

    public void addJar(File file) throws IOException {
        this.addJar(file, false);
    }

    public void addJar(File file, boolean removeEntryTimestamp) throws IOException {
        this.logger.verbose("addJar(%1$s)", new Object[]{file});
        this.init();
        Closer localCloser = Closer.create();
        try {
            ZipEntry entry;
            FileInputStream fis = (FileInputStream)localCloser.register((Closeable)new FileInputStream(file));
            ZipInputStream zis = (ZipInputStream)localCloser.register((Closeable)new ZipInputStream(fis));
            while ((entry = zis.getNextEntry()) != null) {
                int count;
                if (entry.isDirectory()) continue;
                String name = entry.getName();
                if (this.filter != null && !this.filter.checkEntry(name)) continue;
                JarEntry newEntry = entry.getMethod() == 0 ? new JarEntry(entry) : new JarEntry(name);
                if (removeEntryTimestamp) {
                    newEntry.setTime(0L);
                }
                this.logger.verbose("addJar(%1$s): entry %2$s", new Object[]{file, name});
                this.jarOutputStream.putNextEntry(newEntry);
                while ((count = zis.read(this.buffer)) != -1) {
                    this.jarOutputStream.write(this.buffer, 0, count);
                }
                this.jarOutputStream.closeEntry();
                zis.closeEntry();
            }
        }
        catch (SignedJarBuilder.IZipEntryFilter.ZipAbortException e) {
            throw new IOException(e);
        }
        finally {
            localCloser.close();
        }
    }

    public void addEntry(String path, byte[] bytes) throws IOException {
        this.init();
        this.jarOutputStream.putNextEntry(new JarEntry(path));
        this.jarOutputStream.write(bytes);
        this.jarOutputStream.closeEntry();
    }

    public void close() throws IOException {
        if (this.closer != null) {
            this.closer.close();
        }
    }
}

