/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.FilterData;
import com.android.build.OutputFile;
import com.android.build.gradle.api.ApkOutputFile;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.tasks.FileSupplier;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.tasks.PackageApplication;
import com.android.build.gradle.tasks.SplitZipAlign;
import com.android.build.gradle.tasks.ZipAlign;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.gradle.api.Task;

public class ApkVariantOutputData
extends BaseVariantOutputData {
    public PackageApplication packageApplicationTask;
    public ZipAlign zipAlignTask;
    public SplitZipAlign splitZipAlign;
    private TaskManager taskManager;
    private int versionCodeOverride = -1;
    private String versionNameOverride = null;

    public ApkVariantOutputData(OutputFile.OutputType outputType, Collection<FilterData> filters, BaseVariantData variantData, TaskManager taskManager) {
        super(outputType, filters, variantData);
        this.taskManager = taskManager;
    }

    @Override
    public void setOutputFile(File file) {
        if (this.zipAlignTask != null) {
            this.zipAlignTask.setOutputFile(file);
        } else {
            this.packageApplicationTask.setOutputFile(file);
        }
    }

    @Override
    public File getOutputFile() {
        if (this.zipAlignTask != null) {
            return this.zipAlignTask.getOutputFile();
        }
        return this.packageApplicationTask == null ? null : this.packageApplicationTask.getOutputFile();
    }

    @Override
    public ImmutableList<ApkOutputFile> getOutputs() {
        ImmutableList.Builder outputs = ImmutableList.builder();
        outputs.add((Object)this.getMainOutputFile());
        if (this.splitZipAlign != null) {
            outputs.addAll(this.splitZipAlign.getOutputSplitFiles());
        } else if (this.packageSplitResourcesTask != null) {
            outputs.addAll(this.packageSplitResourcesTask.getOutputSplitFiles());
        }
        return outputs.build();
    }

    public ZipAlign createZipAlignTask(String taskName, File inputFile, File outputFile) {
        if (this.zipAlignTask != null) {
            throw new RuntimeException(String.format("ZipAlign task for variant '%s' already exists.", this.variantData.getName()));
        }
        InstantRunBuildContext instantRunBuildContext = this.getScope().getVariantScope().getInstantRunBuildContext();
        this.zipAlignTask = this.taskManager.createZipAlignTask(taskName, instantRunBuildContext, inputFile, outputFile);
        this.assembleTask.dependsOn(new Object[]{this.zipAlignTask});
        return this.zipAlignTask;
    }

    public int getVersionCode() {
        if (this.versionCodeOverride > 0) {
            return this.versionCodeOverride;
        }
        return this.variantData.getVariantConfiguration().getVersionCode();
    }

    @Override
    public File getSplitFolder() {
        return this.getOutputFile().getParentFile();
    }

    public String getVersionName() {
        if (this.versionNameOverride != null) {
            return this.versionNameOverride;
        }
        return this.variantData.getVariantConfiguration().getVersionName();
    }

    public void setVersionCodeOverride(int versionCodeOverride) {
        this.versionCodeOverride = versionCodeOverride;
    }

    public int getVersionCodeOverride() {
        return this.versionCodeOverride;
    }

    public void setVersionNameOverride(String versionNameOverride) {
        this.versionNameOverride = versionNameOverride;
    }

    public String getVersionNameOverride() {
        return this.versionNameOverride;
    }

    public List<FileSupplier> getSplitOutputFileSuppliers() {
        ImmutableList.Builder tasks = ImmutableList.builder();
        if (this.splitZipAlign != null || this.packageSplitResourcesTask != null) {
            tasks.addAll(this.splitZipAlign == null ? this.packageSplitResourcesTask.getOutputFileSuppliers() : this.splitZipAlign.getOutputFileSuppliers());
        }
        if (this.packageSplitAbiTask != null && this.splitZipAlign == null) {
            tasks.addAll(this.packageSplitAbiTask.getOutputFileSuppliers());
        }
        return tasks.build();
    }

    public FileSupplier getMetadataFile() throws IOException {
        if (this.splitZipAlign == null) {
            return null;
        }
        return new FileSupplier(){

            @Override
            public Task getTask() {
                return ApkVariantOutputData.this.splitZipAlign;
            }

            public File get() {
                return ApkVariantOutputData.this.splitZipAlign.getApkMetadataFile();
            }
        };
    }
}

