/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.TestAndroidConfig;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.variant.ApplicationVariantFactory;
import com.android.builder.core.AndroidBuilder;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.gradle.api.GradleException;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.internal.reflect.Instantiator;

public class TestVariantFactory
extends ApplicationVariantFactory {
    public TestVariantFactory(Instantiator instantiator, AndroidBuilder androidBuilder, AndroidConfig extension) {
        super(instantiator, androidBuilder, extension);
    }

    @Override
    public boolean hasTestScope() {
        return false;
    }

    @Override
    public void preVariantWork(Project project) {
        TestAndroidConfig testExtension = (TestAndroidConfig)this.extension;
        String path = testExtension.getTargetProjectPath();
        if (path == null) {
            throw new GradleException("targetProjectPath cannot be null in test project " + project.getName());
        }
        if (testExtension.getTargetVariant() == null) {
            throw new GradleException("targetVariant cannot be null in test project " + project.getName());
        }
        DependencyHandler handler = project.getDependencies();
        handler.add("provided", (Object)handler.project((Map)ImmutableMap.of((Object)"path", (Object)path, (Object)"configuration", (Object)(testExtension.getTargetVariant() + "-classes"))));
    }

    @Override
    public void createDefaultComponents(NamedDomainObjectContainer<BuildType> buildTypes, NamedDomainObjectContainer<ProductFlavor> productFlavors, NamedDomainObjectContainer<SigningConfig> signingConfigs) {
        signingConfigs.create("debug");
        buildTypes.create("debug");
    }
}

