/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.OptionalCompilationStep;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.tasks.KickerTask;
import com.android.build.gradle.tasks.MarkerFile;
import java.io.File;
import java.io.IOException;

public class ColdswapArtifactsKickerTask
extends KickerTask {
    @Override
    protected void doFullTaskAction() throws IOException {
        boolean restartDexRequested = this.variantScope.getGlobalScope().isActive(OptionalCompilationStep.RESTART_ONLY);
        boolean changesAreCompatible = this.variantScope.getInstantRunBuildContext().hasPassedVerification();
        MarkerFile.createMarkerFile(this.getMarkerFile(), restartDexRequested || !changesAreCompatible ? MarkerFile.Command.RUN : MarkerFile.Command.BLOCK);
    }

    public static class ConfigAction
    extends KickerTask.ConfigAction<ColdswapArtifactsKickerTask> {
        public ConfigAction(String name, VariantScope scope) {
            super(name, scope);
        }

        public static File getMarkerFile(VariantScope scope) {
            return new File(scope.getInstantRunSupportDir(), "coldswap.marker");
        }

        @Override
        public Class<ColdswapArtifactsKickerTask> getType() {
            return ColdswapArtifactsKickerTask.class;
        }

        @Override
        public void execute(ColdswapArtifactsKickerTask task) {
            super.execute(task);
            task.markerFile = ConfigAction.getMarkerFile(this.scope);
        }
    }
}

