/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.BaseTask;
import com.android.build.gradle.tasks.JackTask;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.DexOptions;
import com.android.builder.core.VariantConfiguration;
import com.android.ide.common.internal.LoggedErrorException;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.ide.common.process.LoggedProcessOutputHandler;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.repository.Revision;
import com.android.utils.FileUtils;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.api.tasks.incremental.InputFileDetails;

@ParallelizableTask
public class JillTask
extends BaseTask {
    private Collection<File> inputLibs;
    private File outputFolder;
    private com.android.build.gradle.internal.dsl.DexOptions dexOptions;

    @TaskAction
    public void taskAction(IncrementalTaskInputs taskInputs) throws LoggedErrorException, InterruptedException, IOException {
        Revision revision = this.getBuilder().getTargetInfo().getBuildTools().getRevision();
        if (revision.compareTo(JackTask.JACK_MIN_REV) < 0) {
            throw new RuntimeException("Jack requires Build Tools " + JackTask.JACK_MIN_REV.toString() + " or later");
        }
        final File outFolder = this.getOutputFolder();
        if (!taskInputs.isIncremental()) {
            FileUtils.emptyFolder((File)outFolder);
        }
        HashSet hashs = Sets.newHashSet();
        WaitableExecutor executor = new WaitableExecutor();
        final ArrayList inputFileDetails = Lists.newArrayList();
        AndroidBuilder builder = this.getBuilder();
        taskInputs.outOfDate((Action)new Action<InputFileDetails>(){

            public void execute(InputFileDetails change) {
                inputFileDetails.add(change.getFile());
            }
        });
        for (File file : inputFileDetails) {
            JillCallable action = new JillCallable(this, file, hashs, outFolder, builder);
            executor.execute((Callable)action);
        }
        taskInputs.removed((Action)new Action<InputFileDetails>(){

            public void execute(InputFileDetails change) {
                File jackFile = JillTask.getJackFileName(outFolder, change.getFile());
                jackFile.delete();
            }
        });
        executor.waitForTasksWithQuickFail(false);
    }

    @Input
    public String getBuildToolsVersion() {
        return this.getBuildTools().getRevision().toString();
    }

    @InputFiles
    public Collection<File> getInputLibs() {
        return this.inputLibs;
    }

    public void setInputLibs(Collection<File> inputLibs) {
        this.inputLibs = inputLibs;
    }

    @OutputDirectory
    public File getOutputFolder() {
        return this.outputFolder;
    }

    public void setOutputFolder(File outputFolder) {
        this.outputFolder = outputFolder;
    }

    @Nested
    public com.android.build.gradle.internal.dsl.DexOptions getDexOptions() {
        return this.dexOptions;
    }

    public void setDexOptions(com.android.build.gradle.internal.dsl.DexOptions dexOptions) {
        this.dexOptions = dexOptions;
    }

    private static String getFileHash(File file) throws IOException {
        HashCode hashCode = Files.hash((File)file, (HashFunction)Hashing.sha1());
        return hashCode.toString();
    }

    public static File getJackFileName(File outFolder, File inputFile) {
        String name = inputFile.getName();
        int pos = name.lastIndexOf(46);
        if (pos != -1) {
            name = name.substring(0, pos);
        }
        String input = inputFile.getAbsolutePath();
        HashFunction hashFunction = Hashing.sha1();
        HashCode hashCode = hashFunction.hashString((CharSequence)input, Charsets.UTF_16LE);
        return new File(outFolder, name + "-" + hashCode.toString() + ".jar");
    }

    public static class PackagedConfigAction
    implements TaskConfigAction<JillTask> {
        private final VariantScope variantScope;

        public PackagedConfigAction(VariantScope scope) {
            this.variantScope = scope;
        }

        @Override
        public String getName() {
            return this.variantScope.getTaskName("jill", "PackagedLibraries");
        }

        @Override
        public Class<JillTask> getType() {
            return JillTask.class;
        }

        @Override
        public void execute(JillTask jillTask) {
            GlobalScope globalScope = this.variantScope.getGlobalScope();
            final AndroidBuilder androidBuilder = globalScope.getAndroidBuilder();
            jillTask.setAndroidBuilder(androidBuilder);
            jillTask.setVariantName(this.variantScope.getVariantConfiguration().getFullName());
            jillTask.setDexOptions(globalScope.getExtension().getDexOptions());
            ConventionMappingHelper.map((Task)jillTask, "inputLibs", new Callable<Set<File>>(){

                @Override
                public Set<File> call() throws Exception {
                    return androidBuilder.getAllPackagedJars((VariantConfiguration)PackagedConfigAction.this.variantScope.getVariantConfiguration());
                }
            });
            jillTask.setOutputFolder(this.variantScope.getJillPackagedLibrariesDir());
        }
    }

    public static class RuntimeTaskConfigAction
    implements TaskConfigAction<JillTask> {
        private final VariantScope variantScope;

        public RuntimeTaskConfigAction(VariantScope scope) {
            this.variantScope = scope;
        }

        @Override
        public String getName() {
            return this.variantScope.getTaskName("jill", "RuntimeLibraries");
        }

        @Override
        public Class<JillTask> getType() {
            return JillTask.class;
        }

        @Override
        public void execute(JillTask jillTask) {
            GlobalScope globalScope = this.variantScope.getGlobalScope();
            final AndroidBuilder androidBuilder = globalScope.getAndroidBuilder();
            jillTask.setAndroidBuilder(androidBuilder);
            jillTask.setVariantName(this.variantScope.getVariantConfiguration().getFullName());
            jillTask.setDexOptions(globalScope.getExtension().getDexOptions());
            ConventionMappingHelper.map((Task)jillTask, "inputLibs", new Callable<List<File>>(){

                @Override
                public List<File> call() throws Exception {
                    return androidBuilder.getBootClasspath(false);
                }
            });
            jillTask.setOutputFolder(this.variantScope.getJillRuntimeLibrariesDir());
        }
    }

    private final class JillCallable
    implements Callable<Void> {
        private final File fileToProcess;
        private final Set<String> hashs;
        private final DexOptions options;
        private final File outFolder;
        private final AndroidBuilder builder;

        private JillCallable(JillTask enclosing, File file, Set<String> hashs, File outFolder, AndroidBuilder builder) {
            this.options = JillTask.this.getDexOptions();
            this.fileToProcess = file;
            this.hashs = hashs;
            this.outFolder = outFolder;
            this.builder = builder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            String hash = JillTask.getFileHash(this.fileToProcess);
            Set<String> set = this.hashs;
            synchronized (set) {
                if (this.hashs.contains(hash)) {
                    return null;
                }
                this.hashs.add(hash);
            }
            File jackFile = JillTask.getJackFileName(this.outFolder, this.fileToProcess);
            this.builder.convertLibraryToJack(this.fileToProcess, jackFile, this.options, (ProcessOutputHandler)new LoggedProcessOutputHandler(this.builder.getLogger()));
            return null;
        }

        public final File getOutFolder() {
            return this.outFolder;
        }
    }
}

