/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.FilterData;
import com.android.build.OutputFile;
import com.android.build.gradle.api.ApkOutputFile;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.AbiSplitOptions;
import com.android.build.gradle.internal.model.FilterDataImpl;
import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.tasks.PackageApplication;
import com.android.build.gradle.tasks.SplitRelatedTask;
import com.android.builder.model.ApiVersion;
import com.android.builder.model.SigningConfig;
import com.android.builder.packaging.DuplicateFileException;
import com.android.builder.packaging.PackagerException;
import com.android.builder.packaging.SigningException;
import com.android.ide.common.signing.KeytoolException;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Callables;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.Task;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.api.tasks.TaskAction;

@ParallelizableTask
public class PackageSplitAbi
extends SplitRelatedTask {
    private ImmutableList<ApkOutputFile> outputFiles;
    private Collection<File> inputFiles;
    private File outputDirectory;
    private Set<String> splits;
    private String outputBaseName;
    private boolean jniDebuggable;
    private SigningConfig signingConfig;
    private Collection<File> jniFolders;
    private ApiVersion minSdkVersion;

    @OutputFiles
    public List<File> getOutputFiles() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String split : this.splits) {
            String apkName = this.getApkName(split);
            builder.add((Object)new File(this.outputDirectory, apkName));
        }
        return builder.build();
    }

    @Override
    public File getApkMetadataFile() {
        return null;
    }

    public synchronized ImmutableList<ApkOutputFile> getOutputSplitFiles() {
        if (this.outputFiles == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (String split : this.splits) {
                String apkName = this.getApkName(split);
                ApkOutputFile apkOutput = new ApkOutputFile(OutputFile.OutputType.SPLIT, (Collection<FilterData>)ImmutableList.of((Object)FilterDataImpl.build(OutputFile.ABI, apkName)), Callables.returning((Object)new File(this.outputDirectory, apkName)));
                builder.add((Object)apkOutput);
            }
            this.outputFiles = builder.build();
        }
        return this.outputFiles;
    }

    private boolean isAbiSplit(String fileName) {
        for (String abi : this.getSplits()) {
            if (!fileName.contains(abi)) continue;
            return true;
        }
        return false;
    }

    @TaskAction
    protected void doFullTaskAction() throws FileNotFoundException, SigningException, KeytoolException, DuplicateFileException, PackagerException {
        Pattern pattern = Pattern.compile("resources-" + this.getOutputBaseName() + "-(.*).ap_");
        ArrayList unprocessedSplits = Lists.newArrayList(this.splits);
        for (File file : this.inputFiles) {
            Matcher matcher = pattern.matcher(file.getName());
            if (!matcher.matches() || !this.isAbiSplit(file.getName())) continue;
            String apkName = this.getApkName(matcher.group(1));
            File outFile = new File(this.getOutputDirectory(), apkName);
            this.getBuilder().packageApk(file.getAbsolutePath(), (Set)ImmutableSet.of(), (Collection)ImmutableList.of(), this.getJniFolders(), (Set)ImmutableSet.of((Object)matcher.group(1)), this.isJniDebuggable(), this.getSigningConfig(), outFile.getAbsolutePath(), this.getMinSdkVersion());
            unprocessedSplits.remove(matcher.group(1));
        }
        if (!unprocessedSplits.isEmpty()) {
            String message = "Could not find resource package for " + Joiner.on((char)',').join((Iterable)unprocessedSplits);
            this.getLogger().error(message);
            throw new IllegalStateException(message);
        }
    }

    @Override
    public List<FilterData> getSplitsData() {
        ImmutableList.Builder filterDataBuilder = ImmutableList.builder();
        SplitRelatedTask.addAllFilterData((ImmutableList.Builder<FilterData>)filterDataBuilder, this.splits, OutputFile.FilterType.ABI);
        return filterDataBuilder.build();
    }

    private String getApkName(String split) {
        String archivesBaseName = (String)this.getProject().getProperties().get("archivesBaseName");
        String apkName = archivesBaseName + "-" + this.getOutputBaseName() + "_" + split;
        return apkName + (this.getSigningConfig() == null ? "-unsigned.apk" : "-unaligned.apk");
    }

    public void setOutputFiles(ImmutableList<ApkOutputFile> outputFiles) {
        this.outputFiles = outputFiles;
    }

    @InputFiles
    public Collection<File> getInputFiles() {
        return this.inputFiles;
    }

    public void setInputFiles(Collection<File> inputFiles) {
        this.inputFiles = inputFiles;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @Input
    public Set<String> getSplits() {
        return this.splits;
    }

    public void setSplits(Set<String> splits) {
        this.splits = splits;
    }

    @Input
    public String getOutputBaseName() {
        return this.outputBaseName;
    }

    public void setOutputBaseName(String outputBaseName) {
        this.outputBaseName = outputBaseName;
    }

    @Input
    public boolean isJniDebuggable() {
        return this.jniDebuggable;
    }

    public void setJniDebuggable(boolean jniDebuggable) {
        this.jniDebuggable = jniDebuggable;
    }

    @Nested
    @Optional
    public SigningConfig getSigningConfig() {
        return this.signingConfig;
    }

    public void setSigningConfig(SigningConfig signingConfig) {
        this.signingConfig = signingConfig;
    }

    @Input
    public Collection<File> getJniFolders() {
        return this.jniFolders;
    }

    public void setJniFolders(Collection<File> jniFolders) {
        this.jniFolders = jniFolders;
    }

    public void setMinSdkVersion(ApiVersion version) {
        this.minSdkVersion = version;
    }

    @Input
    public int getMinSdkVersion() {
        return this.minSdkVersion.getApiLevel();
    }

    public static class ConfigAction
    implements TaskConfigAction<PackageSplitAbi> {
        private VariantScope scope;

        public ConfigAction(VariantScope scope) {
            this.scope = scope;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("package", "SplitAbi");
        }

        @Override
        public Class<PackageSplitAbi> getType() {
            return PackageSplitAbi.class;
        }

        @Override
        public void execute(PackageSplitAbi packageSplitAbiTask) {
            BaseVariantData<? extends BaseVariantOutputData> variantData = this.scope.getVariantData();
            List<? extends BaseVariantOutputData> outputs = variantData.getOutputs();
            BaseVariantOutputData variantOutputData = outputs.get(0);
            final GradleVariantConfiguration config = this.scope.getVariantConfiguration();
            variantOutputData.packageSplitAbiTask = packageSplitAbiTask;
            ImmutableSet<String> filters = AbiSplitOptions.getAbiFilters(this.scope.getGlobalScope().getExtension().getSplits().getAbiFilters());
            packageSplitAbiTask.setInputFiles(this.scope.getSplitAbiResOutputFiles());
            packageSplitAbiTask.setSplits((Set<String>)filters);
            packageSplitAbiTask.setOutputBaseName(config.getBaseName());
            packageSplitAbiTask.setSigningConfig(config.getSigningConfig());
            packageSplitAbiTask.setOutputDirectory(this.scope.getSplitOutputDirectory());
            packageSplitAbiTask.setAndroidBuilder(this.scope.getGlobalScope().getAndroidBuilder());
            packageSplitAbiTask.setVariantName(config.getFullName());
            packageSplitAbiTask.setMinSdkVersion(config.getMinSdkVersion());
            ConventionMappingHelper.map((Task)packageSplitAbiTask, "jniFolders", new Callable<Set<File>>(){

                @Override
                public Set<File> call() throws Exception {
                    return ConfigAction.this.scope.getTransformManager().getPipelineOutput(PackageApplication.sNativeLibsFilter).keySet();
                }
            });
            ConventionMappingHelper.map((Task)packageSplitAbiTask, "jniDebuggable", new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return config.getBuildType().isJniDebuggable();
                }
            });
        }
    }
}

