/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks.annotations;

import com.android.build.gradle.tasks.annotations.Extractor;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class TypedefRemover {
    private final Extractor mExtractor;
    private final boolean mQuiet;
    private final boolean mVerbose;
    private final boolean mDryRun;
    private Set<String> mAnnotationNames = Sets.newHashSet();
    private List<File> mAnnotationClassFiles = Lists.newArrayList();
    private Set<File> mAnnotationOuterClassFiles = Sets.newHashSet();

    public TypedefRemover(Extractor extractor, boolean quiet, boolean verbose, boolean dryRun) {
        this.mExtractor = extractor;
        this.mQuiet = quiet;
        this.mVerbose = verbose;
        this.mDryRun = dryRun;
    }

    public void remove(File classDir, List<String> owners) {
        if (!this.mQuiet) {
            this.mExtractor.info("Deleting @IntDef and @StringDef annotation class files");
        }
        for (String owner : owners) {
            File file = new File(classDir, owner.replace('/', File.separatorChar) + ".class");
            this.addTypeDef(owner, file);
        }
        this.rewriteOuterClasses();
        this.deleteAnnotationClasses();
    }

    private void addTypeDef(String name, File file) {
        this.mAnnotationClassFiles.add(file);
        this.mAnnotationNames.add(name);
        String fileName = file.getName();
        int index = fileName.lastIndexOf(36);
        if (index != -1) {
            File parentFile = file.getParentFile();
            assert (parentFile != null) : file;
            File container = new File(parentFile, fileName.substring(0, index) + ".class");
            if (container.exists()) {
                this.mAnnotationOuterClassFiles.add(container);
            } else {
                Extractor.error("Warning: Could not find outer class " + container + " for typedef " + file);
            }
        }
    }

    private void rewriteOuterClasses() {
        for (File file : this.mAnnotationOuterClassFiles) {
            byte[] bytes;
            try {
                bytes = Files.toByteArray((File)file);
            }
            catch (IOException e) {
                Extractor.error("Could not read " + file + ": " + e.getLocalizedMessage());
                continue;
            }
            ClassWriter classWriter = new ClassWriter(327680);
            ClassVisitor classVisitor = new ClassVisitor(327680, (ClassVisitor)classWriter){

                public void visitInnerClass(String name, String outerName, String innerName, int access) {
                    if (!TypedefRemover.this.mAnnotationNames.contains(name)) {
                        super.visitInnerClass(name, outerName, innerName, access);
                    }
                }
            };
            ClassReader reader = new ClassReader(bytes);
            reader.accept(classVisitor, 0);
            byte[] rewritten = classWriter.toByteArray();
            try {
                Files.write((byte[])rewritten, (File)file);
            }
            catch (IOException e) {
                Extractor.error("Could not write " + file + ": " + e.getLocalizedMessage());
            }
        }
    }

    private void deleteAnnotationClasses() {
        for (File mFile : this.mAnnotationClassFiles) {
            boolean deleted;
            if (this.mVerbose) {
                if (this.mDryRun) {
                    this.mExtractor.info("Would delete " + mFile);
                } else {
                    this.mExtractor.info("Deleting " + mFile);
                }
            }
            if (this.mDryRun || (deleted = mFile.delete())) continue;
            Extractor.warning("Could not delete " + mFile);
        }
    }
}

