/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks.factory;

import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.builder.core.VariantType;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.internal.file.collections.DefaultConfigurableFileCollection;
import org.gradle.api.reporting.DirectoryReport;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.testing.JUnitXmlReport;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.TestTaskReports;

public class UnitTestConfigAction
implements TaskConfigAction<Test> {
    final VariantScope scope;

    public UnitTestConfigAction(VariantScope scope) {
        this.scope = scope;
    }

    @Override
    public String getName() {
        return this.scope.getTaskName(VariantType.UNIT_TEST.getPrefix());
    }

    @Override
    public Class<Test> getType() {
        return Test.class;
    }

    @Override
    public void execute(Test runTestsTask) {
        final TestVariantData variantData = (TestVariantData)this.scope.getVariantData();
        final BaseVariantData testedVariantData = (BaseVariantData)((Object)variantData.getTestedVariantData());
        runTestsTask.systemProperty("java.awt.headless", (Object)"true");
        runTestsTask.setGroup("verification");
        runTestsTask.setDescription("Run unit tests for the " + testedVariantData.getVariantConfiguration().getFullName() + " build.");
        UnitTestConfigAction.fixTestTaskSources(runTestsTask);
        runTestsTask.setTestClassesDir(this.scope.getJavaOutputDir());
        ConventionMappingHelper.map((Task)runTestsTask, "classpath", new Callable<ConfigurableFileCollection>(){

            @Override
            public ConfigurableFileCollection call() throws Exception {
                Iterable filteredBootClasspath = Iterables.filter((Iterable)UnitTestConfigAction.this.scope.getGlobalScope().getAndroidBuilder().getBootClasspath(false), (Predicate)new Predicate<File>(){

                    public boolean apply(File file) {
                        Preconditions.checkState((file != null ? 1 : 0) != 0);
                        return !"android.jar".equals(file.getName());
                    }
                });
                ArrayList classpaths = Lists.newArrayList();
                JavaCompile testCompileTask = variantData.javacTask;
                if (testCompileTask != null) {
                    classpaths.add(testCompileTask.getClasspath());
                    classpaths.add(testCompileTask.getOutputs().getFiles());
                } else {
                    classpaths.add(testedVariantData.getScope().getJavaOuptuts());
                    classpaths.add(UnitTestConfigAction.this.scope.getJavaOuptuts());
                }
                classpaths.add(variantData.getJavaResourcesForUnitTesting());
                classpaths.add(testedVariantData.getJavaResourcesForUnitTesting());
                classpaths.add(filteredBootClasspath);
                classpaths.add(UnitTestConfigAction.this.scope.getGlobalScope().getMockableAndroidJarFile());
                return UnitTestConfigAction.this.scope.getGlobalScope().getProject().files(new Object[]{classpaths});
            }
        });
        TestTaskReports testTaskReports = runTestsTask.getReports();
        JUnitXmlReport xmlReport = testTaskReports.getJunitXml();
        xmlReport.setDestination((Object)(xmlReport.getDestination() != null ? new File(xmlReport.getDestination(), testedVariantData.getName()) : new File(this.scope.getGlobalScope().getTestResultsFolder(), testedVariantData.getName())));
        DirectoryReport htmlReport = testTaskReports.getHtml();
        htmlReport.setDestination((Object)(htmlReport.getDestination() != null ? new File(htmlReport.getDestination(), testedVariantData.getName()) : new File(this.scope.getGlobalScope().getTestReportFolder(), testedVariantData.getName())));
        this.scope.getGlobalScope().getExtension().getTestOptions().getUnitTests().applyConfiguration(runTestsTask);
    }

    private static void fixTestTaskSources(Test testTask) {
        ((DefaultConfigurableFileCollection)testTask.getInputs().getSourceFiles()).getFrom().clear();
    }
}

