/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.internal.scope.VariantScope;
import com.android.builder.dependency.level2.Dependency;
import com.android.builder.dependency.level2.DependencyNode;
import com.android.builder.dependency.level2.JavaDependency;
import com.android.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.gradle.api.Project;
import org.gradle.api.tasks.diagnostics.internal.TextReportRenderer;
import org.gradle.internal.graph.GraphRenderer;
import org.gradle.internal.logging.text.StyledTextOutput;

public class AndroidAsciiReportRenderer
extends TextReportRenderer {
    private boolean hasConfigs;
    private boolean hasCyclicDependencies;
    private GraphRenderer renderer;
    private Project project;

    public void startProject(Project project) {
        this.project = project;
        super.startProject(project);
        this.hasConfigs = false;
        this.hasCyclicDependencies = false;
    }

    public void completeProject(Project project) {
        if (!this.hasConfigs) {
            this.getTextOutput().withStyle(StyledTextOutput.Style.Info).println((Object)"No dependencies");
        }
        super.completeProject(project);
    }

    public void startVariant(VariantScope variantScope) {
        if (this.hasConfigs) {
            this.getTextOutput().println();
        }
        this.hasConfigs = true;
        this.renderer = new GraphRenderer(this.getTextOutput());
        this.renderer.visit(styledTextOutput -> {
            this.getTextOutput().withStyle(StyledTextOutput.Style.Identifier).text((Object)variantScope.getFullVariantName());
            this.getTextOutput().withStyle(StyledTextOutput.Style.Description).text((Object)"");
        }, true);
    }

    public void render() throws IOException {
        this.renderNow();
    }

    void renderNow() {
    }

    public void complete() {
        if (this.hasCyclicDependencies) {
            this.getTextOutput().withStyle(StyledTextOutput.Style.Info).println((Object)"\n(*) - dependencies omitted (listed previously)");
        }
        super.complete();
    }

    private void render(DependencyNode node, Map<Object, Dependency> dependencyMap, boolean lastChild) {
        this.renderer.visit(styledTextOutput -> {
            JavaDependency javaDependency;
            String name = node.getAddress().toString();
            Dependency dependency = (Dependency)dependencyMap.get(name);
            if (dependency instanceof JavaDependency && (javaDependency = (JavaDependency)dependency).isLocal()) {
                name = FileUtils.relativePath((File)javaDependency.getArtifactFile(), (File)this.project.getProjectDir());
            }
            this.getTextOutput().text((Object)name);
        }, lastChild);
        this.renderChildren((List<DependencyNode>)node.getDependencies(), dependencyMap);
    }

    private void renderChildren(List<DependencyNode> dependencyNodes, Map<Object, Dependency> dependencyMap) {
        this.renderer.startChildren();
        int count = dependencyNodes.size();
        for (int i = 0; i < count; ++i) {
            DependencyNode node = dependencyNodes.get(i);
            this.render(node, dependencyMap, i == count - 1);
        }
        this.renderer.completeChildren();
    }
}

