/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.api;

import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.api.BaseVariantOutput;
import com.android.build.gradle.api.JavaCompileOptions;
import com.android.build.gradle.api.SourceKind;
import com.android.build.gradle.internal.api.ImmutableFlavorList;
import com.android.build.gradle.internal.api.ReadOnlyObjectProvider;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.TaskContainer;
import com.android.build.gradle.tasks.AidlCompile;
import com.android.build.gradle.tasks.ExternalNativeBuildTask;
import com.android.build.gradle.tasks.GenerateBuildConfig;
import com.android.build.gradle.tasks.MergeResources;
import com.android.build.gradle.tasks.MergeSourceSetFolders;
import com.android.build.gradle.tasks.NdkCompile;
import com.android.build.gradle.tasks.RenderscriptCompile;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.model.BuildType;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.SourceProvider;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.compile.JavaCompile;

public abstract class BaseVariantImpl
implements BaseVariant {
    protected AndroidBuilder androidBuilder;
    protected ReadOnlyObjectProvider readOnlyObjectProvider;
    protected NamedDomainObjectContainer<BaseVariantOutput> outputs;

    BaseVariantImpl(AndroidBuilder androidBuilder, ReadOnlyObjectProvider readOnlyObjectProvider, NamedDomainObjectContainer<BaseVariantOutput> outputs) {
        this.androidBuilder = androidBuilder;
        this.readOnlyObjectProvider = readOnlyObjectProvider;
        this.outputs = outputs;
    }

    protected abstract BaseVariantData getVariantData();

    public void addOutputs(List<BaseVariantOutput> outputs) {
        this.outputs.addAll(outputs);
    }

    @Override
    public String getName() {
        return this.getVariantData().getVariantConfiguration().getFullName();
    }

    @Override
    public String getDescription() {
        return this.getVariantData().getDescription();
    }

    @Override
    public String getDirName() {
        return this.getVariantData().getVariantConfiguration().getDirName();
    }

    @Override
    public String getBaseName() {
        return this.getVariantData().getVariantConfiguration().getBaseName();
    }

    @Override
    public String getFlavorName() {
        return this.getVariantData().getVariantConfiguration().getFlavorName();
    }

    @Override
    public Collection<BaseVariantOutput> getOutputs() {
        return this.outputs;
    }

    @Override
    public BuildType getBuildType() {
        return this.readOnlyObjectProvider.getBuildType(this.getVariantData().getVariantConfiguration().getBuildType());
    }

    @Override
    public List<ProductFlavor> getProductFlavors() {
        return new ImmutableFlavorList(this.getVariantData().getVariantConfiguration().getProductFlavors(), this.readOnlyObjectProvider);
    }

    @Override
    public ProductFlavor getMergedFlavor() {
        return this.getVariantData().getVariantConfiguration().getMergedFlavor();
    }

    @Override
    public JavaCompileOptions getJavaCompileOptions() {
        return this.getVariantData().getVariantConfiguration().getJavaCompileOptions();
    }

    @Override
    public List<SourceProvider> getSourceSets() {
        return this.getVariantData().getVariantConfiguration().getSortedSourceProviders();
    }

    @Override
    public List<ConfigurableFileTree> getSourceFolders(SourceKind folderType) {
        switch (folderType) {
            case JAVA: {
                return this.getVariantData().getJavaSources();
            }
        }
        this.androidBuilder.getErrorReporter().handleSyncError(null, 0, "Unknown SourceKind value: " + (Object)((Object)folderType));
        return ImmutableList.of();
    }

    @Override
    public Configuration getCompileConfiguration() {
        return this.getVariantData().getVariantDependency().getCompileClasspath();
    }

    @Override
    public Configuration getRuntimeConfiguration() {
        return this.getVariantData().getVariantDependency().getRuntimeClasspath();
    }

    @Override
    public Configuration getAnnotationProcessorConfiguration() {
        return this.getVariantData().getVariantDependency().getAnnotationProcessorConfiguration();
    }

    @Override
    public String getApplicationId() {
        return this.getVariantData().getApplicationId();
    }

    @Override
    public Task getPreBuild() {
        return this.getVariantData().preBuildTask;
    }

    @Override
    public Task getCheckManifest() {
        return this.getVariantData().checkManifestTask;
    }

    @Override
    public AidlCompile getAidlCompile() {
        return this.getVariantData().aidlCompileTask;
    }

    @Override
    public RenderscriptCompile getRenderscriptCompile() {
        return this.getVariantData().renderscriptCompileTask;
    }

    @Override
    public MergeResources getMergeResources() {
        return this.getVariantData().mergeResourcesTask;
    }

    @Override
    public MergeSourceSetFolders getMergeAssets() {
        return this.getVariantData().mergeAssetsTask;
    }

    @Override
    public GenerateBuildConfig getGenerateBuildConfig() {
        return this.getVariantData().generateBuildConfigTask;
    }

    @Override
    public JavaCompile getJavaCompile() {
        return this.getVariantData().javacTask;
    }

    @Override
    public Task getJavaCompiler() {
        return this.getVariantData().javacTask;
    }

    @Override
    public NdkCompile getNdkCompile() {
        return this.getVariantData().ndkCompileTask;
    }

    @Override
    public Collection<ExternalNativeBuildTask> getExternalNativeBuildTasks() {
        return this.getVariantData().externalNativeBuildTasks;
    }

    @Override
    public Task getObfuscation() {
        return this.getVariantData().obfuscationTask;
    }

    @Override
    public File getMappingFile() {
        VariantScope scope = this.getVariantData().getScope();
        if (scope.hasOutput(TaskOutputHolder.TaskOutputType.APK_MAPPING)) {
            return scope.getOutput(TaskOutputHolder.TaskOutputType.APK_MAPPING).getSingleFile();
        }
        return null;
    }

    public Sync getProcessJavaResources() {
        return this.getVariantData().processJavaResourcesTask;
    }

    @Override
    public Task getAssemble() {
        return this.getVariantData().getTaskByKind(TaskContainer.TaskKind.ASSEMBLE);
    }

    @Override
    public void addJavaSourceFoldersToModel(File ... generatedSourceFolders) {
        this.getVariantData().addJavaSourceFoldersToModel(generatedSourceFolders);
    }

    @Override
    public void addJavaSourceFoldersToModel(Collection<File> generatedSourceFolders) {
        this.getVariantData().addJavaSourceFoldersToModel(generatedSourceFolders);
    }

    @Override
    public void registerJavaGeneratingTask(Task task, File ... sourceFolders) {
        this.getVariantData().registerJavaGeneratingTask(task, sourceFolders);
    }

    @Override
    public void registerJavaGeneratingTask(Task task, Collection<File> sourceFolders) {
        this.getVariantData().registerJavaGeneratingTask(task, sourceFolders);
    }

    @Override
    public void registerExternalAptJavaOutput(ConfigurableFileTree folder) {
        this.getVariantData().registerExternalAptJavaOutput(folder);
    }

    @Override
    public void registerGeneratedResFolders(FileCollection folders) {
        this.getVariantData().registerGeneratedResFolders(folders);
    }

    @Override
    @Deprecated
    public void registerResGeneratingTask(Task task, File ... generatedResFolders) {
        this.getVariantData().registerResGeneratingTask(task, generatedResFolders);
    }

    @Override
    @Deprecated
    public void registerResGeneratingTask(Task task, Collection<File> generatedResFolders) {
        this.getVariantData().registerResGeneratingTask(task, generatedResFolders);
    }

    @Override
    public Object registerPreJavacGeneratedBytecode(FileCollection fileCollection) {
        return this.getVariantData().registerPreJavacGeneratedBytecode(fileCollection);
    }

    @Override
    @Deprecated
    public Object registerGeneratedBytecode(FileCollection fileCollection) {
        return this.registerPreJavacGeneratedBytecode(fileCollection);
    }

    @Override
    public void registerPostJavacGeneratedBytecode(FileCollection fileCollection) {
        this.getVariantData().registerPostJavacGeneratedBytecode(fileCollection);
    }

    @Override
    public FileCollection getCompileClasspath(Object generatorKey) {
        return this.getVariantData().getScope().getJavaClasspath(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactType.CLASSES, generatorKey);
    }

    @Override
    public ArtifactCollection getCompileClasspathArtifacts(Object generatorKey) {
        return this.getVariantData().getScope().getJavaClasspathArtifacts(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactType.CLASSES, generatorKey);
    }

    @Override
    public void buildConfigField(String type, String name, String value) {
        this.getVariantData().getVariantConfiguration().addBuildConfigField(type, name, value);
    }

    @Override
    public void resValue(String type, String name, String value) {
        this.getVariantData().getVariantConfiguration().addResValue(type, name, value);
    }

    @Override
    public void setOutputsAreSigned(boolean isSigned) {
        this.getVariantData().outputsAreSigned = isSigned;
    }

    @Override
    public boolean getOutputsAreSigned() {
        return this.getVariantData().outputsAreSigned;
    }
}

