/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.build.FilterData;
import com.android.build.VariantOutput;
import com.android.build.gradle.internal.ide.AndroidArtifactOutputImpl;
import com.android.build.gradle.internal.ide.BaseArtifactImpl;
import com.android.build.gradle.internal.ide.BuildOutputSupplier;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.SplitScope;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidArtifactOutput;
import com.android.builder.model.ClassField;
import com.android.builder.model.Dependencies;
import com.android.builder.model.InstantRun;
import com.android.builder.model.NativeLibrary;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.level2.DependencyGraphs;
import com.android.ide.common.build.ApkInfo;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

final class AndroidArtifactImpl
extends BaseArtifactImpl
implements AndroidArtifact,
Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean isSigned;
    private final String signingConfigName;
    private final String applicationId;
    private final String sourceGenTaskName;
    private final List<File> generatedResourceFolders;
    private final Set<String> abiFilters;
    private final Collection<NativeLibrary> nativeLibraries;
    private final Map<String, ClassField> buildConfigFields;
    private final Map<String, ClassField> resValues;
    private final InstantRun instantRun;
    private final BuildOutputSupplier<Collection<BuildOutput>> splitOutputsSupplier;
    private final String baseName;
    private final BuildOutputSupplier<Collection<BuildOutput>> manifestSupplier;

    AndroidArtifactImpl(String name, String baseName, String assembleTaskName, boolean isSigned, String signingConfigName, String applicationId, String sourceGenTaskName, String compileTaskName, List<File> generatedSourceFolders, List<File> generatedResourceFolders, File classesFolder, File javaResourcesFolder, Dependencies compileDependencies, DependencyGraphs dependencyGraphs, SourceProvider variantSourceProvider, SourceProvider multiFlavorSourceProviders, Set<String> abiFilters, Collection<NativeLibrary> nativeLibraries, Map<String, ClassField> buildConfigFields, Map<String, ClassField> resValues, InstantRun instantRun, BuildOutputSupplier<Collection<BuildOutput>> splitOutputsSupplier, BuildOutputSupplier<Collection<BuildOutput>> manifestSupplier) {
        super(name, assembleTaskName, compileTaskName, classesFolder, javaResourcesFolder, compileDependencies, dependencyGraphs, variantSourceProvider, multiFlavorSourceProviders, generatedSourceFolders);
        this.baseName = baseName;
        this.isSigned = isSigned;
        this.signingConfigName = signingConfigName;
        this.applicationId = applicationId;
        this.sourceGenTaskName = sourceGenTaskName;
        this.generatedResourceFolders = generatedResourceFolders;
        this.abiFilters = abiFilters;
        this.nativeLibraries = nativeLibraries;
        this.buildConfigFields = buildConfigFields;
        this.resValues = resValues;
        this.instantRun = instantRun;
        this.splitOutputsSupplier = splitOutputsSupplier;
        this.manifestSupplier = manifestSupplier;
    }

    public Collection<AndroidArtifactOutput> getOutputs() {
        Collection manifests = (Collection)this.manifestSupplier.get();
        Collection outputs = (Collection)this.splitOutputsSupplier.get();
        if (outputs.isEmpty()) {
            return manifests.isEmpty() ? this.guessOutputsBasedOnNothing() : this.guessOutputsBaseOnManifests();
        }
        List<BuildOutput> splitApksOutput = outputs.stream().filter(splitOutput -> splitOutput.getApkInfo().getType() == VariantOutput.OutputType.SPLIT).collect(Collectors.toList());
        if (splitApksOutput.isEmpty()) {
            return outputs.stream().map(splitOutput -> new AndroidArtifactOutputImpl((BuildOutput)splitOutput, SplitScope.getOutput((Collection<BuildOutput>)manifests, (TaskOutputHolder.OutputType)TaskOutputHolder.TaskOutputType.MERGED_MANIFESTS, splitOutput.getApkInfo()))).collect(Collectors.toList());
        }
        List mainApks = outputs.stream().filter(splitOutput -> splitOutput.getApkInfo().getType() == VariantOutput.OutputType.MAIN).collect(Collectors.toList());
        if (mainApks.size() != 1) {
            throw new RuntimeException("Invalid main APK outputs : " + Joiner.on((String)",").join(mainApks));
        }
        return ImmutableList.of((Object)new AndroidArtifactOutputImpl((BuildOutput)mainApks.get(0), SplitScope.getOutput((Collection<BuildOutput>)manifests, (TaskOutputHolder.OutputType)TaskOutputHolder.TaskOutputType.MERGED_MANIFESTS, ((BuildOutput)mainApks.get(0)).getApkInfo()), splitApksOutput));
    }

    private Collection<AndroidArtifactOutput> guessOutputsBasedOnNothing() {
        ApkInfo mainApkInfo = ApkInfo.of((VariantOutput.OutputType)VariantOutput.OutputType.MAIN, (Collection)ImmutableList.of(), (int)-1);
        return ImmutableList.of((Object)new AndroidArtifactOutputImpl(new BuildOutput(TaskOutputHolder.TaskOutputType.APK, mainApkInfo, this.splitOutputsSupplier.guessOutputFile(this.baseName + ".apk")), new BuildOutput(TaskOutputHolder.TaskOutputType.APK, mainApkInfo, this.manifestSupplier.guessOutputFile("AndroidManifest.xml"))));
    }

    private Collection<AndroidArtifactOutput> guessOutputsBaseOnManifests() {
        return ((Collection)this.manifestSupplier.get()).stream().map(manifestOutput -> new AndroidArtifactOutputImpl(new BuildOutput(TaskOutputHolder.TaskOutputType.APK, manifestOutput.getApkInfo(), this.splitOutputsSupplier.guessOutputFile(this.baseName + Joiner.on((String)"-").join((Iterable)manifestOutput.getApkInfo().getFilters().stream().map(FilterData::getIdentifier).collect(Collectors.toList())) + ".apk")), (BuildOutput)manifestOutput)).collect(Collectors.toList());
    }

    public boolean isSigned() {
        return this.isSigned;
    }

    public String getSigningConfigName() {
        return this.signingConfigName;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getSourceGenTaskName() {
        return this.sourceGenTaskName;
    }

    public Set<String> getIdeSetupTaskNames() {
        return Sets.newHashSet((Object[])new String[]{this.getSourceGenTaskName()});
    }

    public List<File> getGeneratedResourceFolders() {
        return this.generatedResourceFolders;
    }

    public Set<String> getAbiFilters() {
        return this.abiFilters;
    }

    public Collection<NativeLibrary> getNativeLibraries() {
        return this.nativeLibraries;
    }

    public Map<String, ClassField> getBuildConfigFields() {
        return this.buildConfigFields;
    }

    public Map<String, ClassField> getResValues() {
        return this.resValues;
    }

    public InstantRun getInstantRun() {
        return this.instantRun;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AndroidArtifactImpl that = (AndroidArtifactImpl)o;
        return this.isSigned == that.isSigned && Objects.equals(this.signingConfigName, that.signingConfigName) && Objects.equals(this.applicationId, that.applicationId) && Objects.equals(this.sourceGenTaskName, that.sourceGenTaskName) && Objects.equals(this.generatedResourceFolders, that.generatedResourceFolders) && Objects.equals(this.abiFilters, that.abiFilters) && Objects.equals(this.nativeLibraries, that.nativeLibraries) && Objects.equals(this.buildConfigFields, that.buildConfigFields) && Objects.equals(this.resValues, that.resValues) && Objects.equals(this.manifestSupplier, that.manifestSupplier) && Objects.equals(this.splitOutputsSupplier, that.splitOutputsSupplier) && Objects.equals(this.instantRun, that.instantRun) && Objects.equals(this.baseName, that.baseName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.splitOutputsSupplier, this.manifestSupplier, this.isSigned, this.signingConfigName, this.applicationId, this.sourceGenTaskName, this.generatedResourceFolders, this.abiFilters, this.nativeLibraries, this.buildConfigFields, this.resValues, this.instantRun, this.baseName);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("manifestProxy", this.manifestSupplier).add("splitOutputsSupplier", this.splitOutputsSupplier).add("isSigned", this.isSigned).add("signingConfigName", (Object)this.signingConfigName).add("applicationId", (Object)this.applicationId).add("sourceGenTaskName", (Object)this.sourceGenTaskName).add("generatedResourceFolders", this.generatedResourceFolders).add("abiFilters", this.abiFilters).add("nativeLibraries", this.nativeLibraries).add("buildConfigFields", this.buildConfigFields).add("resValues", this.resValues).add("instantRun", (Object)this.instantRun).toString();
    }
}

