/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.scope;

import com.android.build.gradle.internal.TaskFactory;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.Task;

public class AndroidTask<T extends Task> {
    private String name;
    private final Class<T> taskType;

    public AndroidTask(String name, Class<T> taskType) {
        this.name = name;
        this.taskType = taskType;
    }

    public String getName() {
        return this.name;
    }

    public Class<T> getTaskType() {
        return this.taskType;
    }

    public void dependsOn(TaskFactory taskFactory, final AndroidTask<?> other) {
        taskFactory.named(this.name, (Action<? super Task>)new Action<Task>(){

            public void execute(Task task) {
                task.dependsOn(new Object[]{other.name});
            }
        });
    }

    public void dependsOn(TaskFactory taskFactory, final Object dependency) {
        Preconditions.checkNotNull((Object)dependency);
        taskFactory.named(this.name, (Action<? super Task>)new Action<Task>(){

            public void execute(Task task) {
                if (dependency instanceof AndroidTask) {
                    task.dependsOn(new Object[]{((AndroidTask)dependency).getName()});
                } else {
                    task.dependsOn(new Object[]{dependency});
                }
            }
        });
    }

    public void dependsOn(TaskFactory taskFactory, final Object dependency1, final Object dependency2) {
        Preconditions.checkNotNull((Object)dependency1);
        Preconditions.checkNotNull((Object)dependency2);
        taskFactory.named(this.name, (Action<? super Task>)new Action<Task>(){

            public void execute(Task task) {
                if (dependency1 instanceof AndroidTask) {
                    task.dependsOn(new Object[]{((AndroidTask)dependency1).getName()});
                } else {
                    task.dependsOn(new Object[]{dependency1});
                }
                if (dependency2 instanceof AndroidTask) {
                    task.dependsOn(new Object[]{((AndroidTask)dependency2).getName()});
                } else {
                    task.dependsOn(new Object[]{dependency2});
                }
            }
        });
    }

    public void dependsOn(TaskFactory taskFactory, final Object ... dependencies) {
        for (Object dependency : dependencies) {
            Preconditions.checkNotNull((Object)dependency);
        }
        taskFactory.named(this.name, (Action<? super Task>)new Action<Task>(){

            public void execute(Task task) {
                for (Object dependency : dependencies) {
                    if (dependency instanceof AndroidTask) {
                        task.dependsOn(new Object[]{((AndroidTask)dependency).getName()});
                        continue;
                    }
                    task.dependsOn(new Object[]{dependency});
                }
            }
        });
    }

    public void optionalDependsOn(TaskFactory taskFactory, Object ... dependencies) {
        for (Object dependency : dependencies) {
            if (dependency == null) continue;
            if (dependency instanceof AndroidTask) {
                this.dependsOn(taskFactory, (Object)((AndroidTask)dependency).getName());
                continue;
            }
            this.dependsOn(taskFactory, dependency);
        }
    }

    public void optionalDependsOn(TaskFactory taskFactory, List<?> dependencies) {
        for (Object dependency : dependencies) {
            if (dependency == null) continue;
            this.dependsOn(taskFactory, dependency);
        }
    }

    public void configure(TaskFactory taskFactory, Action<? super T> configAction) {
        taskFactory.named(this.name, configAction);
    }

    public T get(TaskFactory taskFactory) {
        return (T)taskFactory.named(this.name);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("taskType", this.taskType).toString();
    }
}

