/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.DefaultAndroidTask;
import java.io.File;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.api.tasks.TaskAction;

@ParallelizableTask
@CacheableTask
public class CheckManifest
extends DefaultAndroidTask {
    private File manifest;
    private Boolean isOptional;
    private File fakeOutputDir;

    @Optional
    @Input
    public File getManifest() {
        return this.manifest;
    }

    @Input
    public boolean getManifestPresence() {
        return this.manifest != null && this.manifest.isFile();
    }

    public void setManifest(File manifest) {
        this.manifest = manifest;
    }

    @Input
    public Boolean getOptional() {
        return this.isOptional;
    }

    public void setOptional(Boolean optional) {
        this.isOptional = optional;
    }

    @OutputDirectory
    public File getFakeOutputDir() {
        return this.fakeOutputDir;
    }

    @TaskAction
    void check() {
        if (!this.isOptional.booleanValue() && this.manifest != null && !this.manifest.isFile()) {
            throw new IllegalArgumentException(String.format("Main Manifest missing for variant %1$s. Expected path: %2$s", this.getVariantName(), this.getManifest().getAbsolutePath()));
        }
    }

    public static class ConfigAction
    implements TaskConfigAction<CheckManifest> {
        private final VariantScope scope;
        private final boolean isManifestOptional;

        public ConfigAction(VariantScope scope, boolean isManifestOptional) {
            this.scope = scope;
            this.isManifestOptional = isManifestOptional;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("check", "Manifest");
        }

        @Override
        public Class<CheckManifest> getType() {
            return CheckManifest.class;
        }

        @Override
        public void execute(CheckManifest checkManifestTask) {
            this.scope.getVariantData().checkManifestTask = checkManifestTask;
            checkManifestTask.setVariantName(this.scope.getVariantData().getVariantConfiguration().getFullName());
            checkManifestTask.setOptional(this.isManifestOptional);
            checkManifestTask.manifest = this.scope.getVariantData().getVariantConfiguration().getMainManifest();
            checkManifestTask.fakeOutputDir = new File(this.scope.getGlobalScope().getIntermediatesDir(), "check-manifest/" + this.scope.getVariantConfiguration().getDirName());
        }
    }
}

