/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.MergeFileTask;
import java.io.File;
import org.gradle.api.Project;

public class MergeProguardFilesConfigAction
implements TaskConfigAction<MergeFileTask> {
    private final Project project;
    private final VariantScope variantScope;
    private final File outputFile;

    public MergeProguardFilesConfigAction(Project project, VariantScope variantScope, File outputFile) {
        this.project = project;
        this.variantScope = variantScope;
        this.outputFile = outputFile;
    }

    @Override
    public String getName() {
        return this.variantScope.getTaskName("merge", "ProguardFiles");
    }

    @Override
    public Class<MergeFileTask> getType() {
        return MergeFileTask.class;
    }

    @Override
    public void execute(MergeFileTask mergeProguardFiles) {
        mergeProguardFiles.setVariantName(this.variantScope.getVariantConfiguration().getFullName());
        mergeProguardFiles.setInputFiles(this.project.files(new Object[]{this.variantScope.getVariantConfiguration().getConsumerProguardFiles()}).getFiles());
        mergeProguardFiles.setOutputFile(this.outputFile);
    }
}

