/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks.featuresplit;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.commons.io.FileUtils;
import org.gradle.api.file.FileCollection;

public class FeatureSplitDeclaration {
    static final String PERSISTED_FILE_NAME = "feature-split.json";
    private final String uniqueIdentifier;

    public FeatureSplitDeclaration(String uniqueIdentifier) {
        this.uniqueIdentifier = uniqueIdentifier;
    }

    public String getUniqueIdentifier() {
        return this.uniqueIdentifier;
    }

    public void save(File outputDirectory) throws IOException {
        File outputFile = new File(outputDirectory, PERSISTED_FILE_NAME);
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.create();
        FileUtils.write((File)outputFile, (CharSequence)gson.toJson((Object)this));
    }

    public static FeatureSplitDeclaration load(FileCollection input) throws IOException {
        File persistedFile = FeatureSplitDeclaration.getOutputFile(input);
        if (persistedFile == null) {
            throw new FileNotFoundException("No feature split declaration present");
        }
        return FeatureSplitDeclaration.load(persistedFile);
    }

    public static FeatureSplitDeclaration load(File input) throws FileNotFoundException {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.create();
        return (FeatureSplitDeclaration)gson.fromJson((Reader)new FileReader(input), FeatureSplitDeclaration.class);
    }

    private static File getOutputFile(FileCollection input) {
        for (File file : input.getAsFileTree().getFiles()) {
            if (!file.getName().equals(PERSISTED_FILE_NAME)) continue;
            return file;
        }
        return null;
    }

    public static File getOutputFile(File directory) {
        return new File(directory, PERSISTED_FILE_NAME);
    }
}

