/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.VariantOutput;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.VariantModel;
import com.android.build.gradle.internal.api.ApplicationVariantImpl;
import com.android.build.gradle.internal.api.BaseVariantImpl;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.SplitFactory;
import com.android.build.gradle.internal.scope.SplitScope;
import com.android.build.gradle.internal.variant.ApplicationVariantData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantFactory;
import com.android.build.gradle.internal.variant.SplitHandlingPolicy;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.VariantType;
import com.android.builder.profile.Recorder;
import com.android.utils.Pair;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Set;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.internal.reflect.Instantiator;

public class ApplicationVariantFactory
extends BaseVariantFactory
implements VariantFactory {
    public ApplicationVariantFactory(GlobalScope globalScope, Instantiator instantiator, AndroidBuilder androidBuilder, AndroidConfig extension) {
        super(globalScope, androidBuilder, instantiator, extension);
    }

    @Override
    public BaseVariantData createVariantData(GradleVariantConfiguration variantConfiguration, TaskManager taskManager, Recorder recorder) {
        ApplicationVariantData variant = new ApplicationVariantData(this.globalScope, this.extension, variantConfiguration, taskManager, this.androidBuilder.getErrorReporter(), recorder);
        variant.calculateFilters(this.extension.getSplits());
        Set<String> densities = variant.getFilters(VariantOutput.FilterType.DENSITY);
        Set<String> abis = variant.getFilters(VariantOutput.FilterType.ABI);
        if (!densities.isEmpty()) {
            variant.setCompatibleScreens(this.extension.getSplits().getDensity().getCompatibleScreens());
        }
        SplitScope splitScope = variant.getSplitScope();
        SplitFactory splitFactory = variant.getSplitFactory();
        if (splitScope.getSplitHandlingPolicy() == SplitHandlingPolicy.PRE_21_POLICY) {
            if (abis.isEmpty()) {
                if (densities.isEmpty()) {
                    splitFactory.addMainApk();
                } else {
                    splitFactory.addUniversalApk();
                }
            } else {
                if (this.extension.getSplits().getAbi().isEnable() && this.extension.getSplits().getAbi().isUniversalApk()) {
                    splitFactory.addUniversalApk();
                }
                abis.forEach(abi -> splitFactory.addFullSplit((ImmutableList<Pair<VariantOutput.FilterType, String>>)ImmutableList.of((Object)Pair.of((Object)VariantOutput.FilterType.ABI, (Object)abi))));
            }
            for (String density : densities) {
                if (!abis.isEmpty()) {
                    for (String abi2 : abis) {
                        splitFactory.addFullSplit((ImmutableList<Pair<VariantOutput.FilterType, String>>)ImmutableList.of((Object)Pair.of((Object)VariantOutput.FilterType.ABI, (Object)abi2), (Object)Pair.of((Object)VariantOutput.FilterType.DENSITY, (Object)density)));
                    }
                    continue;
                }
                splitFactory.addFullSplit((ImmutableList<Pair<VariantOutput.FilterType, String>>)ImmutableList.of((Object)Pair.of((Object)VariantOutput.FilterType.DENSITY, (Object)density)));
            }
        } else {
            splitFactory.addMainApk();
        }
        return variant;
    }

    @Override
    public Class<? extends BaseVariantImpl> getVariantImplementationClass(BaseVariantData variantData) {
        return ApplicationVariantImpl.class;
    }

    @Override
    public Collection<VariantType> getVariantConfigurationTypes() {
        return ImmutableList.of((Object)VariantType.DEFAULT);
    }

    @Override
    public boolean hasTestScope() {
        return true;
    }

    @Override
    public void validateModel(VariantModel model) {
    }

    @Override
    public void createDefaultComponents(NamedDomainObjectContainer<BuildType> buildTypes, NamedDomainObjectContainer<ProductFlavor> productFlavors, NamedDomainObjectContainer<SigningConfig> signingConfigs) {
        signingConfigs.create("debug");
        buildTypes.create("debug");
        buildTypes.create("release");
    }
}

