/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.external.gson.NativeBuildConfigValue;
import com.android.build.gradle.external.gson.NativeLibraryValue;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.dsl.CoreExternalNativeBuildOptions;
import com.android.build.gradle.internal.dsl.CoreExternalNativeCmakeOptions;
import com.android.build.gradle.internal.dsl.CoreExternalNativeNdkBuildOptions;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.BaseTask;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.tasks.ExternalNativeBuildTaskUtils;
import com.android.build.gradle.tasks.ExternalNativeJsonGenerator;
import com.android.builder.core.AndroidBuilder;
import com.android.ide.common.process.BuildCommandException;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.utils.FileUtils;
import com.android.utils.StringHelper;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.TaskAction;

public class ExternalNativeBuildTask
extends BaseTask {
    private List<File> nativeBuildConfigurationsJsons;
    private File soFolder;
    private File objFolder;
    private Set<String> targets;
    private Map<Abi, File> stlSharedObjectFiles;

    protected void diagnostic(String format, Object ... args) {
        this.getLogger().info(String.format(this.getName() + ": " + format, args));
    }

    @TaskAction
    void build() throws BuildCommandException, IOException {
        NativeLibraryValue libraryValue;
        this.diagnostic("starting build", new Object[0]);
        Preconditions.checkNotNull((Object)this.getVariantName());
        this.diagnostic("reading expected JSONs", new Object[0]);
        Collection<NativeBuildConfigValue> configValueList = ExternalNativeBuildTaskUtils.getNativeBuildConfigValues(this.nativeBuildConfigurationsJsons, this.getVariantName());
        this.diagnostic("done reading expected JSONs", new Object[0]);
        ArrayList buildCommands = Lists.newArrayList();
        ArrayList libraryNames = Lists.newArrayList();
        if (this.targets.isEmpty()) {
            this.diagnostic("executing build commands for targets that produce .so files", new Object[0]);
        } else {
            this.diagnostic("executing build commands for targets: '%s'", Joiner.on((String)", ").join(this.targets));
            HashSet matchingTargets = Sets.newHashSet();
            HashSet unmatchedTargets = Sets.newHashSet();
            for (NativeBuildConfigValue config : configValueList) {
                if (config.libraries == null) continue;
                for (NativeLibraryValue libraryValue2 : config.libraries.values()) {
                    if (this.targets.contains(libraryValue2.artifactName)) {
                        matchingTargets.add(libraryValue2.artifactName);
                        continue;
                    }
                    unmatchedTargets.add(libraryValue2.artifactName);
                }
            }
            for (String target : this.targets) {
                if (matchingTargets.contains(target)) continue;
                throw new GradleException(String.format("Unexpected native build target %s. Valid values are: %s", target, Joiner.on((String)", ").join((Iterable)unmatchedTargets)));
            }
        }
        for (NativeBuildConfigValue config : configValueList) {
            if (config.libraries == null) continue;
            for (String libraryName : config.libraries.keySet()) {
                libraryValue = config.libraries.get(libraryName);
                if (!this.targets.isEmpty() && !this.targets.contains(libraryValue.artifactName)) {
                    this.diagnostic("not building target %s because it isn't in targets set", libraryValue.artifactName);
                    continue;
                }
                if (Strings.isNullOrEmpty((String)libraryValue.buildCommand)) {
                    this.diagnostic("not building target %s because there was no build command for it", libraryValue.artifactName);
                    continue;
                }
                if (this.targets.isEmpty()) {
                    if (libraryValue.output == null) {
                        this.diagnostic("not building target %s because no targets are specified and library build output file is null", libraryValue.artifactName);
                        continue;
                    }
                    String extension = Files.getFileExtension((String)libraryValue.output.getName());
                    if (!extension.equals("so")) {
                        this.diagnostic("not building target %s because no targets are specified and library build output file extension isn't 'so'. Output file is %s", libraryValue.artifactName, libraryValue.output);
                        continue;
                    }
                    this.diagnostic("building target %s because no targets are specified and library build output file extension is 'so'.", libraryValue.artifactName);
                }
                buildCommands.add(libraryValue.buildCommand);
                libraryNames.add(libraryValue.artifactName + " " + libraryValue.abi);
                this.diagnostic("about to build %s", libraryValue.buildCommand);
            }
        }
        this.executeProcessBatch(libraryNames, buildCommands);
        this.diagnostic("check expected build outputs", new Object[0]);
        for (NativeBuildConfigValue config : configValueList) {
            if (config.libraries == null) continue;
            for (String library : config.libraries.keySet()) {
                libraryValue = config.libraries.get(library);
                String libraryName = libraryValue.artifactName + " " + libraryValue.abi;
                Preconditions.checkNotNull((Object)libraryValue);
                Preconditions.checkNotNull((Object)libraryValue.output);
                Preconditions.checkState((!Strings.isNullOrEmpty((String)libraryValue.artifactName) ? 1 : 0) != 0);
                if (!this.targets.isEmpty() && !this.targets.contains(libraryValue.artifactName) || !libraryNames.contains(libraryName)) continue;
                if (!libraryValue.output.exists()) {
                    throw new GradleException(String.format("Expected output file at %s for target %s but there was none", libraryValue.output, libraryValue.artifactName));
                }
                if (libraryValue.abi == null) {
                    throw new GradleException("Expected NativeLibraryValue to have non-null abi");
                }
                Abi abi = Abi.getByName(libraryValue.abi);
                if (abi == null) {
                    throw new RuntimeException(String.format("Unknown ABI seen %s", libraryValue.abi));
                }
                File expectedOutputFile = FileUtils.join((File)this.objFolder, (String[])new String[]{abi.getName(), libraryValue.output.getName()});
                if (FileUtils.isSameFile((File)libraryValue.output, (File)expectedOutputFile)) continue;
                this.diagnostic("external build set its own library output location for '%s', copy to expected location", libraryValue.output.getName());
                if (expectedOutputFile.getParentFile().mkdirs()) {
                    this.diagnostic("created folder %s", expectedOutputFile.getParentFile());
                }
                this.diagnostic("copy file %s to %s", libraryValue.output, expectedOutputFile);
                Files.copy((File)libraryValue.output, (File)expectedOutputFile);
            }
        }
        if (!this.stlSharedObjectFiles.isEmpty()) {
            this.diagnostic("copy STL shared object files", new Object[0]);
            for (Abi abi : this.stlSharedObjectFiles.keySet()) {
                File stlSharedObjectFile = (File)Preconditions.checkNotNull((Object)this.stlSharedObjectFiles.get((Object)abi));
                File objAbi = FileUtils.join((File)this.objFolder, (String[])new String[]{abi.getName(), stlSharedObjectFile.getName()});
                if (!objAbi.getParentFile().isDirectory()) {
                    this.diagnostic("didn't copy STL file to %s because that folder wasn't created by the build ", objAbi.getParentFile());
                    continue;
                }
                this.diagnostic("copy file %s to %s", stlSharedObjectFile, objAbi);
                Files.copy((File)stlSharedObjectFile, (File)objAbi);
            }
        }
        this.diagnostic("build complete", new Object[0]);
    }

    protected void executeProcessBatch(List<String> libraryNames, List<String> commands) throws BuildCommandException, IOException {
        for (int library = libraryNames.size() - 1; library >= 0; --library) {
            String libraryName = libraryNames.get(library);
            this.getLogger().lifecycle(String.format("Build %s", libraryName));
            String command = commands.get(library);
            List tokens = StringHelper.tokenizeString((String)command);
            ProcessInfoBuilder processBuilder = new ProcessInfoBuilder();
            processBuilder.setExecutable((String)tokens.get(0));
            for (int i = 1; i < tokens.size(); ++i) {
                processBuilder.addArgs((String)tokens.get(i));
            }
            this.diagnostic("%s", processBuilder);
            ExternalNativeBuildTaskUtils.executeBuildProcessAndLogError(this.getBuilder(), processBuilder, true);
        }
    }

    public File getSoFolder() {
        return this.soFolder;
    }

    private void setSoFolder(File soFolder) {
        this.soFolder = soFolder;
    }

    private void setTargets(Set<String> targets) {
        this.targets = targets;
    }

    public File getObjFolder() {
        return this.objFolder;
    }

    private void setObjFolder(File objFolder) {
        this.objFolder = objFolder;
    }

    public List<File> getNativeBuildConfigurationsJsons() {
        return this.nativeBuildConfigurationsJsons;
    }

    private void setNativeBuildConfigurationsJsons(List<File> nativeBuildConfigurationsJsons) {
        this.nativeBuildConfigurationsJsons = nativeBuildConfigurationsJsons;
    }

    public void setStlSharedObjectFiles(Map<Abi, File> stlSharedObjectFiles) {
        this.stlSharedObjectFiles = stlSharedObjectFiles;
    }

    public static class ConfigAction
    implements TaskConfigAction<ExternalNativeBuildTask> {
        private final String buildTargetAbi;
        private final ExternalNativeJsonGenerator generator;
        private final VariantScope scope;
        private final AndroidBuilder androidBuilder;

        public ConfigAction(String buildTargetAbi, ExternalNativeJsonGenerator generator, VariantScope scope, AndroidBuilder androidBuilder) {
            this.buildTargetAbi = buildTargetAbi;
            this.generator = generator;
            this.scope = scope;
            this.androidBuilder = androidBuilder;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("externalNativeBuild");
        }

        @Override
        public Class<ExternalNativeBuildTask> getType() {
            return ExternalNativeBuildTask.class;
        }

        @Override
        public void execute(ExternalNativeBuildTask task) {
            Set<String> targets;
            BaseVariantData variantData = this.scope.getVariantData();
            CoreExternalNativeBuildOptions nativeBuildOptions = variantData.getVariantConfiguration().getExternalNativeBuildOptions();
            switch (this.generator.getNativeBuildSystem()) {
                case CMAKE: {
                    Object options = (CoreExternalNativeCmakeOptions)Preconditions.checkNotNull((Object)nativeBuildOptions.getExternalNativeCmakeOptions());
                    targets = options.getTargets();
                    break;
                }
                case NDK_BUILD: {
                    Object options = (CoreExternalNativeNdkBuildOptions)Preconditions.checkNotNull((Object)nativeBuildOptions.getExternalNativeNdkBuildOptions());
                    targets = options.getTargets();
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected native build system " + this.generator.getNativeBuildSystem().getName());
                }
            }
            task.setStlSharedObjectFiles(this.generator.getStlSharedObjectFiles());
            task.setTargets(targets);
            task.setVariantName(variantData.getName());
            task.setSoFolder(this.generator.getSoFolder());
            task.setObjFolder(this.generator.getObjFolder());
            if (Strings.isNullOrEmpty((String)this.buildTargetAbi)) {
                task.setNativeBuildConfigurationsJsons(this.generator.getNativeBuildConfigurationsJsons());
            } else {
                List<File> expectedJson = ExternalNativeBuildTaskUtils.getOutputJsons(this.generator.getJsonFolder(), Arrays.asList(this.buildTargetAbi.split(",")));
                expectedJson.retainAll(this.generator.getNativeBuildConfigurationsJsons());
                if (expectedJson.isEmpty()) {
                    this.androidBuilder.getErrorReporter().handleSyncWarning(this.scope.getFullVariantName(), 16, String.format("Targeted device ABI or comma-delimited ABIs [%s] is not one of [%s]. Nothing to build.", this.buildTargetAbi, Joiner.on((String)", ").join((Iterable)this.generator.getAbis().stream().map(Abi::getName).collect(Collectors.toList()))));
                } else {
                    task.setNativeBuildConfigurationsJsons(Lists.newArrayList((Object[])new File[]{expectedJson.iterator().next()}));
                }
            }
            task.setAndroidBuilder(this.androidBuilder);
            variantData.externalNativeBuildTasks.add(task);
        }
    }
}

