/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.dsl.Splits;
import com.android.build.gradle.internal.scope.SplitList;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.BaseTask;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class SplitsDiscovery
extends BaseTask {
    FileCollection mergedResourcesFolders;
    Set<String> densityFilters;
    boolean densityAuto;
    Set<String> languageFilters;
    boolean languageAuto;
    Set<String> abiFilters;
    Collection<String> resourceConfigs;
    File persistedList;

    @InputFiles
    FileCollection getMergedResourcesFolders() {
        return this.mergedResourcesFolders;
    }

    @Input
    @Optional
    Set<String> getDensityFilters() {
        return this.densityFilters;
    }

    @Input
    @Optional
    boolean isDensityAuto() {
        return this.densityAuto;
    }

    @Input
    @Optional
    Set<String> getLanguageFilters() {
        return this.languageFilters;
    }

    @Input
    @Optional
    boolean isLanguageAuto() {
        return this.languageAuto;
    }

    @Input
    @Optional
    Set<String> getAbiFilters() {
        return this.abiFilters;
    }

    @Input
    Collection<String> getResourceConfigs() {
        return this.resourceConfigs;
    }

    @OutputFile
    File getPersistedList() {
        return this.persistedList;
    }

    @TaskAction
    void taskAction() throws IOException {
        Set mergedResourcesFolderFiles = this.getMergedResourcesFolders().getFiles();
        Collection<String> resConfigs = this.resourceConfigs;
        if (this.resourceConfigs.size() == 1 && ((String)Iterators.getOnlyElement(this.resourceConfigs.iterator())).equals("auto")) {
            resConfigs = this.discoverListOfResourceConfigsNotDensities();
        }
        SplitList.save(this.getPersistedList(), this.getFilters(mergedResourcesFolderFiles, DiscoverableFilterType.DENSITY), this.getFilters(mergedResourcesFolderFiles, DiscoverableFilterType.LANGUAGE), this.getFilters((Iterable<File>)ImmutableList.of(), DiscoverableFilterType.ABI), resConfigs);
    }

    private Set<String> getFilters(Iterable<File> resourceFolders, DiscoverableFilterType filterType) {
        HashSet<String> filtersList = new HashSet<String>();
        if (filterType.isAuto(this)) {
            filtersList.addAll(SplitsDiscovery.getAllFilters(resourceFolders, filterType.folderPrefix));
        } else {
            filtersList.addAll(filterType.getConfiguredFilters(this));
        }
        return filtersList;
    }

    public List<String> discoverListOfResourceConfigsNotDensities() {
        ArrayList<String> resFoldersOnDisk = new ArrayList<String>();
        resFoldersOnDisk.addAll(SplitsDiscovery.getAllFilters((Iterable<File>)this.mergedResourcesFolders, DiscoverableFilterType.LANGUAGE.folderPrefix));
        return resFoldersOnDisk;
    }

    private static List<String> getAllFilters(Iterable<File> resourceFolders, String ... prefixes) {
        ArrayList<String> providedResFolders = new ArrayList<String>();
        for (File resFolder : resourceFolders) {
            File[] subResFolders = resFolder.listFiles();
            if (subResFolders == null) continue;
            for (File subResFolder : subResFolders) {
                for (String prefix : prefixes) {
                    if (!subResFolder.getName().startsWith(prefix)) continue;
                    providedResFolders.add(SplitsDiscovery.getFilter(subResFolder, prefix));
                }
            }
        }
        return providedResFolders;
    }

    private static String getFilter(File file, String prefix) {
        int firstUnderscore;
        if (file.isDirectory()) {
            return file.getName().substring(prefix.length());
        }
        if (file.isFile() && file.getName().endsWith(".flat") && (firstUnderscore = file.getName().indexOf(95)) > -1) {
            return file.getName().substring(prefix.length(), firstUnderscore);
        }
        return "";
    }

    public static final class ConfigAction
    implements TaskConfigAction<SplitsDiscovery> {
        private final VariantScope variantScope;
        private final File persistedList;

        public ConfigAction(VariantScope variantScope, File persistedList) {
            this.variantScope = variantScope;
            this.persistedList = persistedList;
        }

        @Override
        public String getName() {
            return this.variantScope.getTaskName("splitsDiscoveryTask");
        }

        @Override
        public Class<SplitsDiscovery> getType() {
            return SplitsDiscovery.class;
        }

        @Override
        public void execute(SplitsDiscovery task) {
            task.setVariantName(this.variantScope.getFullVariantName());
            Splits splits = this.variantScope.getGlobalScope().getExtension().getSplits();
            task.persistedList = this.persistedList;
            if (splits.getDensity().isEnable()) {
                task.densityFilters = splits.getDensityFilters();
                task.densityAuto = splits.getDensity().isAuto();
            }
            if (splits.getLanguage().isEnable()) {
                task.languageFilters = splits.getLanguageFilters();
                task.languageAuto = splits.getLanguage().isAuto();
            }
            if (splits.getAbi().isEnable()) {
                task.abiFilters = splits.getAbiFilters();
            }
            task.mergedResourcesFolders = this.variantScope.getOutput(TaskOutputHolder.TaskOutputType.MERGED_RES);
            task.resourceConfigs = this.variantScope.getVariantConfiguration().getMergedFlavor().getResourceConfigurations();
        }
    }

    private static enum DiscoverableFilterType {
        DENSITY("drawable-"){

            @Override
            Collection<String> getConfiguredFilters(SplitsDiscovery task) {
                return task.getDensityFilters() != null ? task.getDensityFilters() : ImmutableList.of();
            }

            @Override
            boolean isAuto(SplitsDiscovery task) {
                return task.isDensityAuto();
            }
        }
        ,
        LANGUAGE("values-"){

            @Override
            Collection<String> getConfiguredFilters(SplitsDiscovery task) {
                return task.getLanguageFilters() != null ? task.getLanguageFilters() : ImmutableList.of();
            }

            @Override
            boolean isAuto(SplitsDiscovery task) {
                return task.isLanguageAuto();
            }
        }
        ,
        ABI(""){

            @Override
            Collection<String> getConfiguredFilters(SplitsDiscovery task) {
                return task.getAbiFilters() != null ? task.getAbiFilters() : ImmutableList.of();
            }

            @Override
            boolean isAuto(SplitsDiscovery task) {
                return false;
            }
        };

        private String folderPrefix;

        private DiscoverableFilterType(String folderPrefix) {
            this.folderPrefix = folderPrefix;
        }

        abstract Collection<String> getConfiguredFilters(SplitsDiscovery var1);

        abstract boolean isAuto(SplitsDiscovery var1);
    }
}

