/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks.factory;

import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.tasks.TaskInputHelper;
import java.io.File;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.tasks.Copy;

public class JacocoAgentConfigAction
implements TaskConfigAction<Copy> {
    private final GlobalScope scope;

    public JacocoAgentConfigAction(GlobalScope scope) {
        this.scope = scope;
    }

    @Override
    public String getName() {
        return "unzipJacocoAgent";
    }

    @Override
    public Class<Copy> getType() {
        return Copy.class;
    }

    @Override
    public void execute(Copy task) {
        Project project = this.scope.getProject();
        Configuration config = project.getConfigurations().getByName("androidJacocoAgent");
        Supplier<Collection<File>> jacocoAgent = TaskInputHelper.bypassFileSupplier(() -> ((Configuration)config).getFiles());
        Callable<Collection> callable = () -> ((Collection)jacocoAgent.get()).stream().map(arg_0 -> ((Project)project).zipTree(arg_0)).collect(Collectors.toList());
        task.from(new Object[]{callable});
        task.include(new String[]{this.scope.getJacocoAgent().getName()});
        task.into((Object)this.scope.getJacocoAgentOutputDirectory());
        task.dependsOn(new Object[]{config});
    }
}

